/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="memory")
@Singleton
public class MemoryPingDataProvider
implements PingDataProvider {
    private static final String PROPERTY_MAX_MEMORY = "maxMemory";
    private static final String PROPERTY_TOTAL_MEMORY = "totalMemory";
    private static final String PROPERTY_FREE_MEMORY = "freeMemory";
    private static final String PROPERTY_USED_MEMORY = "usedMemory";

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "long");
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(PROPERTY_MAX_MEMORY, map);
        propertiesMap.put(PROPERTY_TOTAL_MEMORY, map);
        propertiesMap.put(PROPERTY_FREE_MEMORY, map);
        propertiesMap.put(PROPERTY_USED_MEMORY, map);
        return propertiesMap;
    }

    @Override
    public Map<String, Object> provideData() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(PROPERTY_MAX_MEMORY, Runtime.getRuntime().maxMemory());
        jsonMap.put(PROPERTY_TOTAL_MEMORY, Runtime.getRuntime().totalMemory());
        jsonMap.put(PROPERTY_FREE_MEMORY, Runtime.getRuntime().freeMemory());
        jsonMap.put(PROPERTY_USED_MEMORY, Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        return jsonMap;
    }
}

