/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal;

import io.searchbox.client.JestClient;
import io.searchbox.client.config.HttpClientConfig;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.activeinstalls.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.internal.XWikiJestClientFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;

@Component
@Singleton
public class DefaultJestClientManager
implements JestClientManager,
Initializable,
Disposable {
    @Inject
    private Logger logger;
    @Inject
    private ActiveInstallsConfiguration configuration;
    private JestClient client;

    public void initialize() {
        String pingURL = this.configuration.getPingInstanceURL();
        if (!StringUtils.isEmpty((CharSequence)pingURL)) {
            HttpClientConfig clientConfig = ((HttpClientConfig.Builder)new HttpClientConfig.Builder(pingURL).multiThreaded(true)).build();
            XWikiJestClientFactory factory = new XWikiJestClientFactory(this.configuration);
            factory.setHttpClientConfig(clientConfig);
            this.client = factory.getObject();
        }
    }

    public void dispose() {
        if (this.client != null) {
            this.client.shutdownClient();
        }
    }

    @Override
    public JestClient getClient() {
        return this.client;
    }
}

