/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.server;

import io.searchbox.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Count;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.server.DataManager;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultDataManager
implements DataManager {
    private static final String JSON_QUERY_NAME = "query";
    @Inject
    private JestClientManager jestClientManager;

    @Override
    public long getInstallCount(String query) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(JSON_QUERY_NAME, query);
        queryMap.put("lowercase_expanded_terms", false);
        HashMap<String, JSONObject> queryStringMap = new HashMap<String, JSONObject>();
        queryStringMap.put("query_string", JSONObject.fromObject(queryMap));
        HashMap<String, JSONObject> jsonMap = new HashMap<String, JSONObject>();
        jsonMap.put(JSON_QUERY_NAME, JSONObject.fromObject(queryStringMap));
        return this.executeCount(JSONObject.fromObject(jsonMap).toString());
    }

    private long executeCount(String query) throws Exception {
        Count count = ((Count.Builder)((Count.Builder)new Count.Builder().query(query).addIndex("installs")).addType("install")).build();
        JestResult result = this.jestClientManager.getClient().execute((Action)count);
        if (!result.isSucceeded()) {
            throw new Exception(String.format("Error while executing Count query [%s]: [%s], Reason: [%s]", query, result.getErrorMessage(), result.getJsonString()));
        }
        return ((Double)result.getValue("count")).longValue();
    }
}

