/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.administration.test.po;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.administration.test.po.AbstractUserProfilePage;
import org.xwiki.test.ui.po.editor.ChangeAvatarPage;
import org.xwiki.test.ui.po.editor.ProfileEditPage;
import org.xwiki.test.ui.po.editor.wysiwyg.EditorElement;

public class ProfileUserProfilePage
extends AbstractUserProfilePage {
    @FindBy(xpath="//div[@class='userInfo']/div[@class='editProfileCategory']/a")
    private WebElement editProfile;
    @FindBy(className="given-name")
    private WebElement userFirstName;
    @FindBy(className="family-name")
    private WebElement userLastName;
    @FindBy(className="org")
    private WebElement userCompany;
    @FindBy(className="note")
    private WebElement userAbout;
    @FindBy(className="email")
    private WebElement userEmail;
    @FindBy(className="tel")
    private WebElement userPhone;
    @FindBy(className="adr")
    private WebElement userAddress;
    @FindBy(xpath="//dd[1]/span[@class='wikiexternallink']")
    private WebElement userBlog;
    @FindBy(xpath="//dd[2]/span[@class='wikiexternallink']")
    private WebElement userBlogFeed;
    @FindBy(xpath="//div[@id='avatar']//a")
    private WebElement changeAvatar;
    @FindBy(xpath="//div[@id='avatar']//img")
    private WebElement userAvatarImage;

    public static ProfileUserProfilePage gotoPage(String username) {
        ProfileUserProfilePage page = new ProfileUserProfilePage(username);
        ProfileUserProfilePage.getUtil().gotoPage("XWiki", page.getUsername());
        return page;
    }

    public ProfileUserProfilePage(String username) {
        super(username);
    }

    public ProfileEditPage editProfile() {
        this.editProfile.click();
        this.waitForProfileEditionToLoad();
        return new ProfileEditPage();
    }

    public void waitForProfileEditionToLoad() {
        new EditorElement("XWiki.XWikiUsers_0_comment").waitToLoad();
        new EditorElement("XWiki.XWikiUsers_0_address").waitToLoad();
    }

    public String getURL() {
        return ProfileUserProfilePage.getUtil().getURL("XWiki", this.getUsername());
    }

    public String getUserFirstName() {
        return this.userFirstName.getText();
    }

    public String getUserLastName() {
        return this.userLastName.getText();
    }

    public String getUserCompany() {
        return this.userCompany.getText();
    }

    public String getUserAbout() {
        return this.userAbout.getText();
    }

    public String getUserEmail() {
        return this.userEmail.getText();
    }

    public String getUserPhone() {
        return this.userPhone.getText();
    }

    public String getUserAddress() {
        return this.userAddress.getText();
    }

    public String getUserBlog() {
        return this.userBlog.getText();
    }

    public String getUserBlogFeed() {
        return this.userBlogFeed.getText();
    }

    public ChangeAvatarPage changeAvatarImage() {
        this.changeAvatar.click();
        this.waitUntilElementIsVisible(By.id((String)"uploadAttachment"));
        return new ChangeAvatarPage();
    }

    public String getAvatarImageName() {
        return StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)this.userAvatarImage.getAttribute("src"), (String)"/"), (String)"?");
    }
}

