/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.administration.test.po;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.InlinePage;

public class TemplateProviderInlinePage
extends InlinePage {
    @FindBy(name="XWiki.TemplateProviderClass_0_template")
    private WebElement templateInput;
    @FindBy(name="XWiki.TemplateProviderClass_0_name")
    private WebElement templateNameInput;
    @FindBy(name="XWiki.TemplateProviderClass_0_type")
    private WebElement templateTypeSelect;
    @FindBy(name="XWiki.TemplateProviderClass_0_action")
    private WebElement templateActionSelect;

    public String getTemplateName() {
        return this.templateNameInput.getAttribute("value");
    }

    public void setTemplateName(String value) {
        this.templateNameInput.clear();
        this.templateNameInput.sendKeys(new CharSequence[]{value});
    }

    public String getTemplate() {
        return this.templateInput.getAttribute("value");
    }

    public void setTemplate(String value) {
        this.templateInput.clear();
        this.templateInput.sendKeys(new CharSequence[]{value});
    }

    public boolean isPageTemplate() {
        return this.templateTypeSelect.findElement(By.xpath((String)"//option[@value='page']")).isSelected();
    }

    private List<WebElement> getSpacesInput() {
        return this.getDriver().findElements(By.name((String)"XWiki.TemplateProviderClass_0_spaces"));
    }

    public List<String> getSpaces() {
        ArrayList<String> spaces = new ArrayList<String>();
        for (WebElement input : this.getSpacesInput()) {
            spaces.add(input.getAttribute("value"));
        }
        return spaces;
    }

    public void setSpaces(List<String> spaces) {
        for (WebElement input : this.getSpacesInput()) {
            if (input.isSelected()) {
                input.click();
            }
            if (!spaces.contains(input.getAttribute("value"))) continue;
            input.click();
        }
    }

    public List<String> getSelectedSpaces() {
        ArrayList<String> selectedSpaces = new ArrayList<String>();
        for (WebElement input : this.getSpacesInput()) {
            if (!input.isSelected()) continue;
            selectedSpaces.add(input.getAttribute("value"));
        }
        return selectedSpaces;
    }

    public void excludeSpaces(List<String> spaces) {
        List<String> selectedSpaces = this.getSelectedSpaces();
        if (selectedSpaces.size() == 0 || spaces.containsAll(selectedSpaces)) {
            for (WebElement input : this.getSpacesInput()) {
                if (!input.isSelected() && input.getAttribute("value").length() > 0) {
                    input.click();
                }
                if (!spaces.contains(input.getAttribute("value"))) continue;
                input.click();
            }
        } else {
            for (WebElement input : this.getSpacesInput()) {
                if (!spaces.contains(input.getAttribute("value")) || !input.isSelected()) continue;
                input.click();
            }
        }
    }

    public void setSaveAndEdit() {
        this.templateActionSelect.findElement(By.xpath((String)"//option[@value='saveandedit']")).click();
    }
}

