/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.io.internal;

import com.xpn.xwiki.objects.BaseObjectReference;
import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.annotation.io.IOServiceException;
import org.xwiki.annotation.io.IOTargetService;
import org.xwiki.annotation.reference.TypedStringEntityReferenceResolver;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultIOTargetService
implements IOTargetService {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge dab;
    @Inject
    @Named(value="configured")
    private DocumentDisplayer documentDisplayer;
    @Inject
    private TypedStringEntityReferenceResolver referenceResolver;

    public String getSource(String reference) throws IOServiceException {
        try {
            EntityReference ref = this.referenceResolver.resolve(reference, EntityType.DOCUMENT);
            if (ref.getType() == EntityType.OBJECT_PROPERTY) {
                return this.getObjectPropertyContent(new ObjectPropertyReference(ref));
            }
            if (ref.getType() == EntityType.DOCUMENT) {
                return this.dab.getDocument(new DocumentReference(ref)).getContent();
            }
            return this.dab.getDocumentContent(reference);
        }
        catch (Exception e) {
            throw new IOServiceException("An exception has occurred while getting the source for " + reference, (Throwable)e);
        }
    }

    public String getSourceSyntax(String reference) throws IOServiceException {
        try {
            EntityReference ref = this.referenceResolver.resolve(reference, EntityType.DOCUMENT);
            EntityReference docRef = ref.extractReference(EntityType.DOCUMENT);
            if (docRef != null) {
                return this.dab.getDocument(new DocumentReference(docRef)).getSyntax().toIdString();
            }
            return this.dab.getDocumentSyntaxId(reference);
        }
        catch (Exception e) {
            throw new IOServiceException("An exception has occurred while getting the syntax of the source for " + reference, (Throwable)e);
        }
    }

    public XDOM getXDOM(String reference) throws IOServiceException {
        return this.getXDOM(reference, null);
    }

    public XDOM getXDOM(String reference, String syntax) throws IOServiceException {
        String sourceSyntaxId = syntax;
        if (sourceSyntaxId == null) {
            sourceSyntaxId = this.getSourceSyntax(reference);
        }
        try {
            EntityReference ref = this.referenceResolver.resolve(reference, EntityType.DOCUMENT);
            if (ref.getType() == EntityType.OBJECT_PROPERTY) {
                return this.getTransformedXDOM(this.getObjectPropertyContent(new ObjectPropertyReference(ref)), sourceSyntaxId);
            }
            if (ref.getType() == EntityType.DOCUMENT) {
                return this.getDocumentXDOM(new DocumentReference(ref));
            }
            return this.getTransformedXDOM(this.dab.getDocumentContent(reference), sourceSyntaxId);
        }
        catch (Exception e) {
            throw new IOServiceException("An exception has occurred while getting the XDOM for " + reference, (Throwable)e);
        }
    }

    private XDOM getDocumentXDOM(DocumentReference reference) throws Exception {
        DocumentDisplayerParameters parameters = new DocumentDisplayerParameters();
        parameters.setExecutionContextIsolated(true);
        parameters.setContentTranslated(true);
        parameters.setTargetSyntax(Syntax.XHTML_1_0);
        return this.documentDisplayer.display((Object)this.dab.getDocument(reference), (Object)parameters);
    }

    private XDOM getTransformedXDOM(String content, String sourceSyntaxId) throws ParseException, ComponentLookupException, TransformationException {
        Parser parser = (Parser)this.componentManager.getInstance(Parser.class, sourceSyntaxId);
        XDOM xdom = parser.parse((Reader)new StringReader(content));
        SyntaxFactory syntaxFactory = (SyntaxFactory)this.componentManager.getInstance(SyntaxFactory.class);
        TransformationContext txContext = new TransformationContext(xdom, syntaxFactory.createSyntaxFromIdString(sourceSyntaxId));
        TransformationManager transformationManager = (TransformationManager)this.componentManager.getInstance(TransformationManager.class);
        transformationManager.performTransformations((Block)xdom, txContext);
        return xdom;
    }

    private String getObjectPropertyContent(ObjectPropertyReference reference) {
        BaseObjectReference objRef = new BaseObjectReference(reference.getParent());
        DocumentReference docRef = new DocumentReference(objRef.getParent());
        if (objRef.getObjectNumber() != null) {
            return this.dab.getProperty(docRef, objRef.getXClassReference(), objRef.getObjectNumber().intValue(), reference.getName()).toString();
        }
        return this.dab.getProperty(docRef, objRef.getXClassReference(), reference.getName()).toString();
    }
}

