/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.annotation.event.AnnotationAddedEvent;
import org.xwiki.annotation.event.AnnotationDeletedEvent;
import org.xwiki.annotation.event.AnnotationUpdatedEvent;
import org.xwiki.component.annotation.Role;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Role
@Named(value="AnnotationEventGeneratorEventListener")
@Singleton
public class AnnotationEventGeneratorEventListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new XObjectAddedEvent(), new XObjectUpdatedEvent(), new XObjectDeletedEvent());
    @Inject
    protected AnnotationConfiguration annotationConfiguration;
    @Inject
    protected Provider<ObservationManager> observationManager;
    @Inject
    protected Execution execution;
    @Inject
    protected EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    protected Logger logger;

    public String getName() {
        return this.getClass().getAnnotation(Named.class).value();
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        XWikiContext context = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
        String currentWiki = context.getWikiId();
        try {
            String selection;
            XWikiDocument document = (XWikiDocument)source;
            String wikiOfAffectedDocument = document.getDocumentReference().getWikiReference().getName();
            context.setWikiId(wikiOfAffectedDocument);
            if (!this.annotationConfiguration.isInstalled()) {
                return;
            }
            BaseObjectReference objectReference = this.getBaseObjectReference((XObjectEvent)event);
            DocumentReference objectClassReference = objectReference.getXClassReference();
            if (!objectClassReference.equals((Object)this.annotationConfiguration.getAnnotationClassReference())) {
                return;
            }
            BaseObject object = document.getXObject((ObjectReference)objectReference);
            AnnotationAddedEvent newEvent = null;
            String documentReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
            String number = String.valueOf(objectReference.getObjectNumber());
            if (event instanceof XObjectAddedEvent) {
                newEvent = new AnnotationAddedEvent(documentReference, number);
            } else if (event instanceof XObjectUpdatedEvent) {
                newEvent = new AnnotationUpdatedEvent(documentReference, number);
            } else if (event instanceof XObjectDeletedEvent) {
                object = document.getOriginalDocument().getXObject((ObjectReference)objectReference);
                newEvent = new AnnotationDeletedEvent(documentReference, number);
            }
            DocumentReference defaultCommentsClassReference = context.getWiki().getCommentsClass(context).getDocumentReference();
            if (defaultCommentsClassReference.equals((Object)object.getXClassReference()) && ((selection = object.getStringValue("selection")) == null || selection.trim().length() == 0)) {
                return;
            }
            ((ObservationManager)this.observationManager.get()).notify((Event)newEvent, source, (Object)context);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle event of type [{}]", (Object)event.getClass().getName(), (Object)e);
        }
        finally {
            context.setWikiId(currentWiki);
        }
    }

    private BaseObjectReference getBaseObjectReference(XObjectEvent objectEvent) {
        EntityReference objectReference = objectEvent.getReference();
        BaseObjectReference baseObjectReference = null;
        baseObjectReference = objectReference instanceof BaseObjectReference ? (BaseObjectReference)objectEvent.getReference() : new BaseObjectReference(objectEvent.getReference());
        return baseObjectReference;
    }
}

