/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletResponse;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationService;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.model.jaxb.AnnotatedContent;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.annotation.rest.model.jaxb.AnnotationStub;
import org.xwiki.annotation.rest.model.jaxb.ObjectFactory;
import org.xwiki.annotation.rights.AnnotationRightService;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.XWikiResource;

public abstract class AbstractAnnotationRESTResource
extends XWikiResource {
    protected static final String DEFAULT_ACTION = "view";
    @Inject
    protected AnnotationService annotationService;
    @Inject
    protected AnnotationRightService annotationRightService;
    @Inject
    protected Execution execution;
    @Inject
    protected EntityReferenceSerializer<String> referenceSerializer;

    protected AnnotationResponse getSuccessResponseWithAnnotatedContent(String documentName, AnnotationRequest request) throws AnnotationServiceException, XWikiException {
        ObjectFactory factory = new ObjectFactory();
        AnnotationResponse response = factory.createAnnotationResponse();
        Collection annotations = this.annotationService.getAnnotations(documentName);
        Collection<Annotation> filteredAnnotations = this.filterAnnotations(annotations, request);
        String renderedHTML = this.renderDocumentWithAnnotationsWithoutRedirects(documentName, filteredAnnotations);
        AnnotatedContent annotatedContentResponse = factory.createAnnotatedContent();
        annotatedContentResponse.getAnnotations().addAll(this.prepareAnnotationStubsSet(filteredAnnotations, request.getRequest().getFields()));
        annotatedContentResponse.setContent(renderedHTML);
        response.setAnnotatedContent(annotatedContentResponse);
        response.setResponseCode(0);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderDocumentWithAnnotationsWithoutRedirects(String documentName, Collection<Annotation> filteredAnnotations) throws XWikiException, AnnotationServiceException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiResponse contextResponse = context.getResponse();
        try {
            context.setResponse((XWikiResponse)new XWikiServletResponse((HttpServletResponse)contextResponse){

                public void sendRedirect(String location) {
                }
            });
            String string = this.renderDocumentWithAnnotations(documentName, null, DEFAULT_ACTION, filteredAnnotations);
            return string;
        }
        finally {
            context.setResponse(contextResponse);
        }
    }

    private Collection<AnnotationStub> prepareAnnotationStubsSet(Collection<Annotation> annotations, List<String> requestedFields) {
        ObjectFactory factory = new ObjectFactory();
        ArrayList<AnnotationStub> set = new ArrayList<AnnotationStub>();
        for (Annotation xwikiAnnotation : annotations) {
            AnnotationStub annotation = factory.createAnnotationStub();
            annotation.setAnnotationId(xwikiAnnotation.getId());
            annotation.setState(xwikiAnnotation.getState().toString());
            for (String extraField : requestedFields) {
                Object value = xwikiAnnotation.get(extraField);
                AnnotationField field = new AnnotationField();
                field.setName(extraField);
                field.setValue(value != null ? value.toString() : null);
                annotation.getFields().add(field);
            }
            set.add(annotation);
        }
        return set;
    }

    protected AnnotationResponse getErrorResponse(Throwable exception) {
        AnnotationResponse result = new ObjectFactory().createAnnotationResponse();
        result.setResponseCode(1);
        String responseMessage = exception.getMessage();
        if (responseMessage == null) {
            StringWriter stackTraceWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stackTraceWriter));
            responseMessage = stackTraceWriter.toString();
        }
        result.setResponseMessage(responseMessage);
        result.setAnnotatedContent(null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderDocumentWithAnnotations(String docName, String language, String action, Collection<Annotation> annotations) throws XWikiException, AnnotationServiceException {
        String isInRenderingEngineKey = "isInRenderingEngine";
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        Object isInRenderingEngine = context.get((Object)isInRenderingEngineKey);
        XWikiURLFactory oldFactory = context.getURLFactory();
        int oldMode = context.getMode();
        String result = null;
        try {
            context.setMode(0);
            XWikiURLFactory urlf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
            context.setURLFactory(urlf);
            this.setUpDocuments(docName, language);
            context.setAction(action);
            context.put((Object)isInRenderingEngineKey, (Object)true);
            result = this.annotationService.getAnnotatedRenderedContent(docName, null, "xhtml/1.0", annotations);
        }
        finally {
            if (isInRenderingEngine != null) {
                context.put((Object)isInRenderingEngineKey, isInRenderingEngine);
            } else {
                context.remove((Object)isInRenderingEngineKey);
            }
            context.setURLFactory(oldFactory);
            context.setMode(oldMode);
        }
        return result;
    }

    private void setUpDocuments(String docName, String language) throws XWikiException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        xwiki.prepareResources(context);
        XWikiDocument doc = xwiki.getDocument(docName, context);
        context.put((Object)"doc", (Object)doc);
        context.put((Object)"cdoc", (Object)doc);
        XWikiDocument tdoc = doc.getTranslatedDocument(language, context);
        context.put((Object)"tdoc", (Object)tdoc);
        context.getWiki().renderTemplate("xwikivars.vm", context);
    }

    protected Collection<Annotation> filterAnnotations(Collection<Annotation> annotations, AnnotationRequest request) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        HashMap filters = new HashMap();
        for (AnnotationField annotationField : request.getFilter().getFields()) {
            String filterName = annotationField.getName();
            ArrayList<String> values = (ArrayList<String>)filters.get(filterName);
            if (values == null) {
                values = new ArrayList<String>();
                filters.put(filterName, values);
            }
            if (annotationField.getValue() == null) continue;
            values.add(annotationField.getValue());
        }
        if (filters.size() == 0) {
            return annotations;
        }
        for (Annotation ann : annotations) {
            boolean matches = true;
            for (Map.Entry filter : filters.entrySet()) {
                Object annotationValue = ann.get((String)filter.getKey());
                if (annotationValue != null && ((List)filter.getValue()).contains(annotationValue.toString())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(ann);
        }
        return result;
    }

    protected String getXWikiUser() {
        return (String)this.referenceSerializer.serialize((EntityReference)((XWikiContext)this.xcontextProvider.get()).getUserReference(), new Object[0]);
    }

    protected void updateContext(DocumentReference documentReference) {
        try {
            XWikiContext deprecatedContext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
            deprecatedContext.setWikiId(documentReference.getWikiReference().getName());
            XWiki xwiki = deprecatedContext.getWiki();
            XWikiDocument currentDocument = xwiki.getDocument(documentReference, deprecatedContext);
            deprecatedContext.setDoc(currentDocument);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to update the context for page [{}].", (Object)documentReference, (Object)e);
        }
    }
}

