/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWikiException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.internal.AbstractAnnotationRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationAddRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationFieldCollection;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="org.xwiki.annotation.rest.internal.AnnotationsRESTResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/annotations")
@Singleton
public class AnnotationsRESTResource
extends AbstractAnnotationRESTResource {
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;

    @GET
    public Response doGetAnnotatedContent(@PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, AnnotationRequest request) {
        try {
            DocumentReference docRef = new DocumentReference(wiki, space, page);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)docRef, new Object[0]);
            if (!this.annotationRightService.canViewAnnotatedTarget(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return Response.ok((Object)response).expires(new Date()).build();
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return Response.ok((Object)this.getErrorResponse(e)).build();
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return Response.ok((Object)this.getErrorResponse(e)).build();
        }
    }

    @POST
    public AnnotationResponse doPostAnnotation(@PathParam(value="wikiName") String wiki, @PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, AnnotationAddRequest request) {
        try {
            DocumentReference docRef = new DocumentReference(wiki, space, page);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)docRef, new Object[0]);
            if (!this.annotationRightService.canAddAnnotation(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Map<String, Object> annotationMetadata = this.getMap(request.getAnnotation());
            this.annotationService.addAnnotation(documentName, request.getSelection(), request.getSelectionContext(), request.getSelectionOffset(), this.getXWikiUser(), annotationMetadata);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return response;
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
    }

    protected Map<String, Object> getMap(AnnotationFieldCollection fields) {
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        for (AnnotationField f : fields.getFields()) {
            metadataMap.put(f.getName(), f.getValue());
        }
        return metadataMap;
    }
}

