/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationManager.class);
    private static final String XWIKIPREFERENCES = "XWiki.XWikiPreferences";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES = "documentBundles";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP = ",";
    private XWikiPluginMessageTool messageTool;

    public ApplicationManager(XWikiPluginMessageTool messageTool) {
        this.messageTool = messageTool;
    }

    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return this.messageTool != null ? this.messageTool : ApplicationManagerMessageTool.getDefault(context);
    }

    public XWikiApplication getRootApplication(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        String docFullName = xwiki.getXWikiPreference("rootapplication", null, context);
        if (docFullName != null && !(doc = xwiki.getDocument(docFullName, context)).isNew()) {
            return XWikiApplicationClass.getInstance(context).newXObjectDocument(doc, 0, context);
        }
        return null;
    }

    public List<XWikiApplication> getApplicationList(XWikiContext context) throws XWikiException {
        return XWikiApplicationClass.getInstance(context, false).searchXObjectDocuments(context);
    }

    public void createApplication(XWikiApplication userAppSuperDoc, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        XWikiApplicationClass appClass;
        XWiki xwiki = context.getWiki();
        XWikiDocument docToSave = xwiki.getDocument((appClass = XWikiApplicationClass.getInstance(context)).getItemDocumentDefaultFullName(userAppSuperDoc.getAppName(), context), context);
        if (!docToSave.isNew() && appClass.isInstance(docToSave)) {
            if (failOnExist) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error(this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
                }
                throw new ApplicationManagerException(60010, this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
            }
        }
        XWikiApplication appSuperDocToSave = XWikiApplicationClass.getInstance(context).newXObjectDocument(docToSave, 0, context);
        appSuperDocToSave.mergeObject(userAppSuperDoc);
        appSuperDocToSave.save(comment);
        userAppSuperDoc.setFullName(appSuperDocToSave.getFullName());
    }

    public void deleteApplication(String appName, XWikiContext context) throws XWikiException {
        XWikiApplication app = this.getApplication(appName, context, true);
        app.delete();
    }

    public XWikiApplication getApplication(String appName, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiApplicationClass.getInstance(context, false).getApplication(appName, validate, context);
    }

    public void reloadApplication(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        this.updateApplicationTranslation(app, comment, context);
    }

    public void reloadAllApplications(String comment, XWikiContext context) throws XWikiException {
        List<XWikiApplication> applist = this.getApplicationList(context);
        for (XWikiApplication app : applist) {
            this.updateApplicationTranslation(app, comment, context);
        }
    }

    public void updateApplicationsTranslation(Collection<XWikiApplication> applications, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null) {
            String documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES);
            List translationPrefs = ListClass.getListFromString((String)documentBundles, (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true);
            boolean updateprefs = false;
            for (XWikiApplication app : applications) {
                updateprefs |= this.updateApplicationTranslation(translationPrefs, app);
            }
            if (updateprefs) {
                prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
                xwiki.saveDocument(prefsDoc, comment, context);
            }
        }
    }

    public void updateAllApplicationTranslation(XWikiContext context) throws XWikiException {
        this.updateApplicationsTranslation(this.getApplicationList(context), this.getMessageTool(context).get("applicationmanager.plugin.comment.refreshalltranslations"), context);
    }

    public void updateApplicationsTranslation(XWikiDocument document, XWikiContext context) throws XWikiException {
        List<XWikiApplication> appList = XWikiApplicationClass.getInstance(context).newXObjectDocumentList(document, context);
        this.updateApplicationsTranslation(appList, this.getMessageTool(context).get("applicationmanager.plugin.comment.autoupdatetranslations", document.getFullName()), context);
    }

    public void updateApplicationTranslation(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        String documentBundles;
        List translationPrefs;
        boolean updateprefs;
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null && (updateprefs = this.updateApplicationTranslation(translationPrefs = ListClass.getListFromString((String)(documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES)), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true), app))) {
            prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
            xwiki.saveDocument(prefsDoc, comment, context);
        }
    }

    public boolean updateApplicationTranslation(List<String> translationPrefs, XWikiApplication app) {
        boolean updateprefs = false;
        List<String> translationDocs = app.getTranslationDocs();
        for (String translationDoc : translationDocs) {
            if (translationPrefs.contains(translationDoc)) continue;
            translationPrefs.add(translationDoc);
            updateprefs = true;
        }
        return updateprefs;
    }
}

