/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.plugin.packaging.DocumentInfoAPI;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.Set;
import org.xwiki.localization.ContextualLocalizationManager;

public class ApplicationPackager {
    private static final String PACKAGEPLUGIN_NAME = "package";
    private ApplicationManager applicationManager;
    private ContextualLocalizationManager localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);

    public ApplicationPackager(XWikiPluginMessageTool messageTool) {
        this();
    }

    public ApplicationPackager() {
        this.applicationManager = new ApplicationManager();
    }

    @Deprecated
    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return ApplicationManagerMessageTool.getDefault(context);
    }

    public void exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory, XWikiContext context) throws XWikiException, IOException {
        XWikiApplication app = this.applicationManager.getApplication(appName, context, true);
        PackageAPI export = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        export.setName(app.getAppName() + "-" + app.getAppVersion());
        Set<String> documents = app.getDocumentsNames(recurse, true);
        for (String documentName : documents) {
            export.add(documentName, 0);
        }
        export.setWithVersions(withDocHistory);
        export.export();
    }

    public void importApplication(XWikiDocument packageDoc, String packageName, String comment, XWikiContext context) throws XWikiException {
        XWikiAttachment packFile = packageDoc.getAttachment(packageName);
        if (packFile == null) {
            throw new ApplicationManagerException(0, this.localizationManager.getTranslationPlain("applicationmanager.plugin.error.import.packagedoesnotexists", new Object[]{packageName}));
        }
        PackageAPI importer = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        try {
            importer.Import(packFile.getContent(context));
        }
        catch (IOException e) {
            throw new ApplicationManagerException(0, this.localizationManager.getTranslationPlain("applicationmanager.plugin.error.import.import", new Object[]{packageName}), e);
        }
        if (importer.install() == 0) {
            throw new ApplicationManagerException(0, this.localizationManager.getTranslationPlain("applicationmanager.plugin.error.import.install", new Object[]{packageName}));
        }
        for (DocumentInfoAPI docinfo : importer.getFiles()) {
            XWikiDocument doc = docinfo.getDocInfo().getDoc();
            if (!XWikiApplicationClass.getInstance(context).isInstance(doc)) continue;
            this.applicationManager.reloadApplication(XWikiApplicationClass.getInstance(context).newXObjectDocument(doc, 0, context), comment, context);
        }
    }
}

