/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocument;
import java.util.List;

public class DefaultXObjectDocument
extends Document
implements XObjectDocument {
    private static final int BOOLEANFIELD_TRUE = 1;
    private static final int BOOLEANFIELD_FALSE = 0;
    private static final int BOOLEANFIELD_MAYBE = 2;
    protected XClassManager sclass;
    protected int objectId;
    protected boolean isNew;

    public DefaultXObjectDocument(XClassManager<? extends XObjectDocument> sclass, XWikiDocument xdoc, int objectId, XWikiContext context) throws XWikiException {
        super(xdoc, context);
        this.sclass = sclass;
        this.objectId = objectId;
        this.reload(context);
    }

    public void setFullName(String docFullName) {
        this.getDoc().setFullName(docFullName, this.context);
    }

    @Override
    public void reload(XWikiContext context) throws XWikiException {
        if (this.getObjectNumbers(this.sclass.getClassFullName()) == 0) {
            if (this.objectId > 0) {
                throw new XWikiException(2, 2, "Object od id " + this.objectId + "does not exist");
            }
            BaseObject object = this.getDoc().newObject(this.sclass.getClassFullName(), context);
            XWikiDocument docTemplate = context.getWiki().getDocument(this.sclass.getClassTemplateFullName(), context);
            BaseObject templateObject = docTemplate.getObject(this.sclass.getClassFullName());
            if (templateObject != null) {
                object.merge(templateObject);
            }
            if (super.isNew()) {
                this.setParent(docTemplate.getParent());
                this.setContent(docTemplate.getContent());
                this.setSyntaxId(docTemplate.getSyntaxId());
            }
            this.isNew = true;
        }
    }

    @Override
    public Document getDocumentApi() {
        return this;
    }

    @Override
    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public Object getObjectApi() {
        BaseObject obj = this.getBaseObject(false);
        return obj == null ? null : obj.newObjectApi(obj, this.context);
    }

    protected BaseObject getBaseObject(boolean toWrite) {
        BaseObject obj = toWrite ? this.getDoc().getObject(this.sclass.getClassFullName(), this.objectId) : this.doc.getObject(this.sclass.getClassFullName(), this.objectId);
        return obj;
    }

    public void mergeObject(DefaultXObjectDocument sdoc) {
        if (this.getXClassManager() != sdoc.getXClassManager()) {
            return;
        }
        BaseObject obj1 = this.getBaseObject(true);
        BaseObject obj2 = sdoc.getBaseObject(false);
        for (java.lang.Object fieldNameObj : obj2.getPropertyList()) {
            String fieldName = (String)fieldNameObj;
            PropertyInterface fieldValue2 = obj2.safeget(fieldName);
            if (fieldValue2 == null) continue;
            obj1.safeput(fieldName, (PropertyInterface)((BaseElement)fieldValue2).clone());
        }
    }

    public XClassManager getXClassManager() {
        return this.sclass;
    }

    @Override
    public boolean isNew() {
        return super.isNew() || this.isNew;
    }

    protected void saveDocument(String comment, boolean minorEdit) throws XWikiException {
        super.saveDocument(comment, minorEdit);
        this.isNew = false;
    }

    public void delete() throws XWikiException {
        if (this.getObjectNumbers(this.sclass.getClassFullName()) == 1) {
            super.delete();
        } else {
            this.doc.removeObject(this.getBaseObject(false));
            this.save();
        }
        this.isNew = true;
    }

    public String getStringValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getStringValue(fieldName);
    }

    public void setStringValue(String fieldName, String value) {
        PropertyClass pclass;
        BaseObject obj = this.getBaseObject(true);
        if (obj != null && (pclass = (PropertyClass)this.sclass.getBaseClass().get(fieldName)) != null) {
            BaseProperty prop = (BaseProperty)obj.safeget(fieldName);
            prop = pclass.fromString(value);
            if (prop != null) {
                obj.safeput(fieldName, (PropertyInterface)prop);
            }
        }
    }

    @Deprecated
    public String getLargeStringValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getLargeStringValue(fieldName);
    }

    @Deprecated
    public void setLargeStringValue(String fieldName, String value) {
        this.setStringValue(fieldName, value);
    }

    public List<String> getStringListValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getListValue(fieldName);
    }

    public void setStringListValue(String fieldName, List<String> value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setStringListValue(fieldName, value);
        }
    }

    @Deprecated
    public List getListValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getListValue(fieldName);
    }

    @Deprecated
    public void setListValue(String fieldName, List value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setStringListValue(fieldName, value);
        }
    }

    public int getIntValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return 0;
        }
        return obj.getIntValue(fieldName);
    }

    public void setIntValue(String fieldName, int value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setIntValue(fieldName, value);
        }
    }

    public Boolean getBooleanValue(String fieldName) {
        int intValue = this.getIntValue(fieldName);
        return intValue == 1 ? Boolean.TRUE : (intValue == 0 ? Boolean.FALSE : null);
    }

    public void setBooleanValue(String fieldName, Boolean value) {
        this.setIntValue(fieldName, value == null ? 2 : (value != false ? 1 : 0));
    }
}

