/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.appwithinminutes.test.po.ClassFieldEditPane;
import org.xwiki.appwithinminutes.test.po.StaticListItemsEditor;

public class StaticListClassFieldEditPane
extends ClassFieldEditPane {
    private WebElement defaultValueContainer = this.getContainer().findElement(By.xpath((String)".//dl[@class = 'field-viewer']/dd"));

    public StaticListClassFieldEditPane(String fieldName) {
        super(fieldName);
    }

    public Select getDisplayTypeSelect() {
        return new Select(this.getPropertyInput("displayType"));
    }

    public WebElement getSizeInput() {
        return this.getPropertyInput("size");
    }

    public WebElement getMultipleSelectionCheckBox() {
        return this.getPropertyInput("multiSelect");
    }

    @Override
    public String getDefaultValue() {
        String displayType = this.getPreviewInputType();
        if ("input".equals(displayType)) {
            return super.getDefaultValue();
        }
        Iterator<WebElement> i$ = this.getSelectedItems().iterator();
        if (i$.hasNext()) {
            WebElement selectedItem = i$.next();
            return selectedItem.getAttribute("value");
        }
        return null;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if ("input".equals(this.getPreviewInputType())) {
            super.setDefaultValue(defaultValue);
        } else {
            for (WebElement selectedItem : this.getSelectedItems()) {
                selectedItem.click();
            }
            this.getItemByValue(defaultValue).click();
        }
    }

    public List<String> getDefaultSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (WebElement selectedItem : this.getSelectedItems()) {
            selectedValues.add(selectedItem.getAttribute("value"));
        }
        return selectedValues;
    }

    protected List<WebElement> getSelectedItems() {
        By xpath = By.xpath((String)".//*[local-name() = 'option' or @type = 'radio' or @type = 'checkbox']");
        ArrayList<WebElement> selectedItems = new ArrayList<WebElement>();
        for (WebElement item : StaticListClassFieldEditPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.defaultValueContainer, xpath)) {
            if (!item.isSelected()) continue;
            selectedItems.add(item);
        }
        return selectedItems;
    }

    public WebElement getItemByValue(String value) {
        By xpath = By.xpath((String)(".//*[@value = '" + value + "']"));
        try {
            return StaticListClassFieldEditPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.defaultValueContainer, xpath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPreviewInputType() {
        By xpath = By.xpath((String)".//*[local-name() = 'select' or (local-name() = 'input' and not(@type = 'hidden'))]");
        List inputs = StaticListClassFieldEditPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.defaultValueContainer, xpath);
        if (inputs.size() > 0) {
            WebElement input = (WebElement)inputs.get(0);
            return "select".equalsIgnoreCase(input.getTagName()) ? "select" : input.getAttribute("type").toLowerCase();
        }
        return null;
    }

    public StaticListItemsEditor getItemsEditor() {
        return new StaticListItemsEditor(StaticListClassFieldEditPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.getContainer(), By.className((String)"staticListEditor")));
    }
}

