/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.util;

import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache<T>
implements Cache<T> {
    private static final Log LOG = LogFactory.getLog(AbstractCache.class);
    protected CacheConfiguration configuration;
    protected final EventListenerList cacheEntryListeners = new EventListenerList();

    @Override
    public void dispose() {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            this.cacheEntryListeners.remove(CacheEntryListener.class, listener);
        }
    }

    @Override
    public void addCacheEntryListener(CacheEntryListener<T> listener) {
        this.cacheEntryListeners.add(CacheEntryListener.class, listener);
    }

    @Override
    public void removeCacheEntryListener(CacheEntryListener<T> listener) {
        this.cacheEntryListeners.remove(CacheEntryListener.class, listener);
    }

    protected void sendEntryAddedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryAdded(event);
        }
    }

    protected void sendEntryRemovedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryRemoved(event);
        }
        this.disposeCacheValue(event.getEntry().getValue());
    }

    protected void sendEntryModifiedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryModified(event);
        }
    }

    protected void disposeCacheValue(T value) {
        block3: {
            if (value instanceof DisposableCacheValue) {
                try {
                    ((DisposableCacheValue)value).dispose();
                }
                catch (Throwable e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Error when trying to dispose a cache object of cache [" + this.configuration.getConfigurationId() + "]"), e);
                }
            }
        }
    }
}

