/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.infinispan.internal.InfinispanCache;
import org.xwiki.cache.infinispan.internal.InfinispanConfigurationLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.container.Container;

@Component
@Named(value="infinispan")
@Singleton
public class InfinispanCacheFactory
implements CacheFactory,
Initializable {
    private static final String DEFAULT_CONFIGURATION_FILE = "/WEB-INF/cache/infinispan/config.xml";
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    private Container container;
    private Configuration defaultConfiguration;
    private EmbeddedCacheManager cacheManager;

    public void initialize() throws InitializationException {
        InputStream configurationStream = this.getConfigurationFileAsStream();
        if (configurationStream != null) {
            try {
                this.cacheManager = new DefaultCacheManager(configurationStream);
            }
            catch (IOException e) {
                throw new InitializationException("Failed to create Infinispan cache manager", (Throwable)e);
            }
            finally {
                try {
                    configurationStream.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close configuration file stream", (Throwable)e);
                }
            }
        }
        this.cacheManager = new DefaultCacheManager();
        this.defaultConfiguration = this.cacheManager.getDefaultConfiguration().clone();
        try {
            this.container = (Container)this.componentManager.lookup(Container.class);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Can't find any Container", (Throwable)e);
        }
    }

    private InputStream getConfigurationFileAsStream() {
        InputStream is = this.container != null && this.container.getApplicationContext() != null ? this.container.getApplicationContext().getResourceAsStream(DEFAULT_CONFIGURATION_FILE) : null;
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cache<T> newCache(CacheConfiguration configuration) throws CacheException {
        String cacheName = configuration.getConfigurationId();
        if (cacheName == null) {
            cacheName = UUID.randomUUID().toString();
        }
        configuration.setConfigurationId(cacheName);
        InfinispanConfigurationLoader loader = new InfinispanConfigurationLoader(configuration);
        boolean configChanged = loader.customize(this.cacheManager.getDefaultConfiguration());
        try {
            InfinispanCache infinispanCache = new InfinispanCache(this.cacheManager, loader.getCacheConfiguration());
            return infinispanCache;
        }
        finally {
            if (configChanged) {
                this.cacheManager.getDefaultConfiguration().applyOverrides(this.defaultConfiguration);
            }
        }
    }
}

