/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import org.apache.commons.lang3.StringUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;

public class InfinispanConfigurationLoader
extends AbstractCacheConfigurationLoader {
    private static final String DEFAULT_FILECACHESTORE_LOCATION = "Infinispan-FileCacheStore";

    public InfinispanConfigurationLoader(CacheConfiguration configuration) {
        super(configuration, null);
    }

    private ConfigurationBuilder builder(ConfigurationBuilder builder, Configuration isconfiguration) {
        if (builder != null) {
            return builder;
        }
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        if (isconfiguration != null) {
            newBuilder.read(isconfiguration);
        }
        return newBuilder;
    }

    private boolean containsIncompleteFileLoader(Configuration isconfiguration) {
        for (Object cacheLoaderConfig : isconfiguration.loaders().cacheLoaders()) {
            FileCacheStoreConfiguration fileCacheLoaderConfig;
            String location;
            if (!(cacheLoaderConfig instanceof FileCacheStoreConfiguration) || !StringUtils.isBlank((CharSequence)(location = (fileCacheLoaderConfig = (FileCacheStoreConfiguration)cacheLoaderConfig).location())) && !location.equals(DEFAULT_FILECACHESTORE_LOCATION)) continue;
            return true;
        }
        return false;
    }

    private ConfigurationBuilder customizeEviction(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        EntryEvictionConfiguration eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction");
        if (eec != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
            if (eec.containsKey((Object)"maxentries")) {
                int maxEntries = ((Number)eec.get((Object)"maxentries")).intValue();
                if (configuration.eviction() == null || configuration.eviction().strategy() != EvictionStrategy.LRU || configuration.eviction().maxEntries() != maxEntries) {
                    builder = this.builder(builder, null);
                    builder.eviction().strategy(EvictionStrategy.LRU);
                    builder.eviction().maxEntries(maxEntries);
                }
            }
            if (eec.getTimeToLive() > 0) {
                long maxIdle = (long)eec.getTimeToLive() * 1000L;
                if (configuration.expiration() == null || configuration.expiration().maxIdle() != maxIdle) {
                    builder = this.builder(builder, null);
                    builder.expiration().maxIdle((long)eec.getTimeToLive() * 1000L);
                }
            }
        }
        return builder;
    }

    private ConfigurationBuilder completeFilesystem(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        if (this.containsIncompleteFileLoader(configuration)) {
            builder = this.builder(builder, configuration);
            LoadersConfigurationBuilder loadersBuilder = builder.loaders();
            loadersBuilder.clearCacheLoaders();
            for (Object cacheLoaderConfig : configuration.loaders().cacheLoaders()) {
                if (cacheLoaderConfig instanceof LoaderConfiguration) {
                    loadersBuilder.addCacheLoader().read((LoaderConfiguration)cacheLoaderConfig);
                    continue;
                }
                if (!(cacheLoaderConfig instanceof FileCacheStoreConfiguration)) continue;
                FileCacheStoreConfiguration fileCacheLoaderConfig = (FileCacheStoreConfiguration)cacheLoaderConfig;
                FileCacheStoreConfigurationBuilder loaderBuilder = loadersBuilder.addFileCacheStore().read(fileCacheLoaderConfig);
                String location = fileCacheLoaderConfig.location();
                if (!StringUtils.isBlank((CharSequence)location) && !location.equals(DEFAULT_FILECACHESTORE_LOCATION)) continue;
                loaderBuilder.location(this.createTempDir());
            }
        }
        return builder;
    }

    public Configuration customize(Configuration defaultConfiguration, Configuration namedConfiguration) {
        ConfigurationBuilder builder = null;
        if (namedConfiguration == null) {
            builder = this.customizeEviction(builder, defaultConfiguration);
        }
        if (namedConfiguration != null) {
            builder = this.completeFilesystem(builder, namedConfiguration);
        }
        return builder != null ? builder.build() : null;
    }
}

