/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.infinispan.internal.InfinispanCacheEntry;
import org.xwiki.cache.infinispan.internal.event.InfinispanCacheEntryEvent;
import org.xwiki.cache.util.AbstractCache;

@Listener
public class InfinispanCache<T>
extends AbstractCache<T> {
    private Cache<String, T> cache;
    private ConcurrentMap<String, T> preEventData = new ConcurrentHashMap<String, T>();
    private EmbeddedCacheManager cacheManager;

    InfinispanCache(EmbeddedCacheManager cacheManager, CacheConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.cache = cacheManager.getCache(configuration.getConfigurationId());
        this.cache.addListener((Object)this);
    }

    public void remove(String key) {
        this.cache.remove((Object)key);
    }

    public void set(String key, T obj) {
        if (obj != null) {
            this.cache.put((Object)key, obj);
        } else {
            this.cache.remove((Object)key);
        }
    }

    public T get(String key) {
        return (T)this.cache.get((Object)key);
    }

    public void removeAll() {
        this.cache.clear();
    }

    public void dispose() {
        super.dispose();
        this.cacheManager.removeCache(this.cache.getName());
    }

    @CacheEntriesEvicted
    public void nodeEvicted(CacheEntriesEvictedEvent<String, T> event) {
        for (Map.Entry entry : event.getEntries().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.cacheEntryRemoved(key, value);
        }
    }

    @CacheEntryExpired
    public void nodeExpired(CacheEntryExpiredEvent<String, T> event) {
        String key = (String)event.getKey();
        Object value = event.getValue();
        this.cacheEntryRemoved(key, value);
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent<String, T> event) {
        String key = (String)event.getKey();
        Object value = event.getValue();
        if (event.isPre()) {
            if (value != null) {
                this.preEventData.put(key, value);
            }
        } else {
            this.cacheEntryRemoved((String)event.getKey(), this.preEventData.get(key));
            this.preEventData.remove(key);
        }
    }

    @CacheEntryCreated
    public void nodeCreated(CacheEntryCreatedEvent<String, T> event) {
        String key = (String)event.getKey();
        if (!event.isPre()) {
            this.cacheEntryInserted(key, event.getValue());
        }
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent<String, T> event) {
        String key = (String)event.getKey();
        Object value = event.getValue();
        if (event.isPre()) {
            if (value != null) {
                this.preEventData.put(key, value);
            }
        } else {
            this.cacheEntryInserted(key, value);
            this.preEventData.remove(key);
        }
    }

    private void cacheEntryInserted(String key, T value) {
        InfinispanCacheEntryEvent<T> event = new InfinispanCacheEntryEvent<T>(new InfinispanCacheEntry<T>(this, key, value));
        Object previousValue = this.preEventData.get(key);
        if (previousValue != null) {
            if (previousValue != value) {
                this.disposeCacheValue(previousValue);
            }
            this.sendEntryModifiedEvent(event);
        } else {
            this.sendEntryAddedEvent(event);
        }
    }

    private void cacheEntryRemoved(String key, T value) {
        InfinispanCacheEntryEvent<T> event = new InfinispanCacheEntryEvent<T>(new InfinispanCacheEntry<T>(this, key, value));
        this.sendEntryRemovedEvent(event);
    }
}

