/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.jbosscache.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.jbosscache.internal.PropertiesLoadingCacheException;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;
import org.xwiki.container.Container;

public class JBossCacheCacheConfiguration
extends AbstractCacheConfigurationLoader {
    public static final String CONFX_EVICTION_WAKEUPINTERVAL = "wakeupinterval";
    private static final Log LOG = LogFactory.getLog(JBossCacheCacheConfiguration.class);
    private static final String PROPS_PATH = "cache/jbosscache/";
    private static final String PROPS_EXT = ".xml";
    private static final String JBCPROP_LOCATION = "location";
    private Configuration jbossConfiguration;
    private Container container;

    public JBossCacheCacheConfiguration(Container container, CacheConfiguration configuration, String defaultPropsId) {
        super(configuration, defaultPropsId);
        this.container = container;
        this.load();
    }

    public Configuration getJBossCacheConfiguration() {
        return this.jbossConfiguration;
    }

    private void load() {
        this.jbossConfiguration = this.loadConfig(this.getCacheConfiguration().getConfigurationId());
        if (this.jbossConfiguration == null) {
            EntryEvictionConfiguration eec;
            this.jbossConfiguration = this.getDefaultConfig();
            if (this.jbossConfiguration == null) {
                this.jbossConfiguration = new Configuration();
            }
            if ((eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction")) != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
                EvictionConfig ec = this.jbossConfiguration.getEvictionConfig();
                if (ec == null) {
                    ec = new EvictionConfig();
                    this.jbossConfiguration.setEvictionConfig(ec);
                }
                if (eec.containsKey((Object)CONFX_EVICTION_WAKEUPINTERVAL)) {
                    ec.setWakeupInterval(((Number)eec.get((Object)CONFX_EVICTION_WAKEUPINTERVAL)).longValue());
                }
                this.setLRUConfiguration(ec.getDefaultEvictionRegionConfig(), eec);
            }
        }
        this.jbossConfiguration.setClusterName(this.getCacheConfiguration().getConfigurationId());
        this.completeCacheLoaderConfiguration();
    }

    private void setLRUConfiguration(EvictionRegionConfig erc, EntryEvictionConfiguration eec) {
        LRUAlgorithmConfig lruc = erc.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig ? (LRUAlgorithmConfig)erc.getEvictionAlgorithmConfig() : new LRUAlgorithmConfig();
        if (eec.containsKey((Object)"maxentries")) {
            lruc.setMaxNodes(((Number)eec.get((Object)"maxentries")).intValue());
        }
        if (eec.getTimeToLive() > 0) {
            lruc.setTimeToLive((long)eec.getTimeToLive(), TimeUnit.SECONDS);
        }
        erc.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)lruc);
    }

    private void completeCacheLoaderConfiguration() {
        CacheLoaderConfig config = this.jbossConfiguration.getCacheLoaderConfig();
        if (config != null) {
            for (CacheLoaderConfig.IndividualCacheLoaderConfig iconfig : config.getIndividualCacheLoaderConfigs()) {
                String location;
                if (!iconfig.getClassName().equals("org.jboss.cache.loader.FileCacheLoader") || (location = (String)iconfig.getProperties().get(JBCPROP_LOCATION)) != null && location.trim().length() != 0) continue;
                iconfig.getProperties().put(JBCPROP_LOCATION, this.createTempDir());
            }
        }
    }

    protected Configuration getDefaultConfig() {
        return this.loadConfig(this.getDefaultPropsId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration loadConfig(String propertiesId) {
        Configuration config = null;
        String propertiesFilename = propertiesId + PROPS_EXT;
        File file = new File(PROPS_PATH + propertiesFilename);
        InputStream is = null;
        try {
            is = file.exists() ? new FileInputStream(file) : this.container.getApplicationContext().getResourceAsStream("/WEB-INF/cache/jbosscache/" + propertiesFilename);
            if (is == null) {
                throw new PropertiesLoadingCacheException("Can't find any configuration file for" + propertiesId);
            }
            XmlConfigurationParser parser = new XmlConfigurationParser();
            config = parser.parseStream(is);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Properties loaded: " + propertiesFilename));
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to load configuration file " + propertiesId), (Throwable)e);
            }
        }
        finally {
            block16: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block16;
                        LOG.debug((Object)"Failed t close properties file", (Throwable)e);
                    }
                }
            }
        }
        return config;
    }
}

