/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.oscache.internal;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.oscache.internal.OSCacheCacheConfiguration;
import org.xwiki.cache.oscache.internal.event.OSCacheCacheEntryEvent;
import org.xwiki.cache.util.AbstractCache;

public class OSCacheCache<T>
extends AbstractCache<T>
implements CacheEntryEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSCacheCache.class);
    private OSCacheCacheConfiguration oscacheConfiguration;
    private GeneralCacheAdministrator cacheAdmin;

    public void initialize(OSCacheCacheConfiguration oscacheConfiguration) {
        this.oscacheConfiguration = oscacheConfiguration;
        this.configuration = this.oscacheConfiguration.getCacheConfiguration();
        this.cacheAdmin = new GeneralCacheAdministrator(this.oscacheConfiguration.getOSCacheProperties());
        this.cacheAdmin.getCache().addCacheEventListener((CacheEventListener)this);
    }

    private String getName() {
        return this.oscacheConfiguration.getName();
    }

    private String cacheKey(String apiKey) {
        return this.getName() != null ? this.getName() + apiKey : apiKey;
    }

    public String apiKey(String cacheKey) {
        return this.getName() != null ? cacheKey.substring(this.getName().length()) : cacheKey;
    }

    public void remove(String key) {
        this.cacheAdmin.flushEntry(this.cacheKey(key));
    }

    public void set(String key, T obj) {
        this.cacheAdmin.putInCache(this.cacheKey(key), obj);
    }

    public T get(String key) {
        Object value;
        block2: {
            value = null;
            String cacheKey = this.cacheKey(key);
            try {
                value = this.cacheAdmin.getFromCache(cacheKey, this.oscacheConfiguration.getTimeToLive());
            }
            catch (NeedsRefreshException e) {
                this.cacheAdmin.cancelUpdate(cacheKey);
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Failed to get the value from the cache", (Throwable)e);
            }
        }
        return (T)value;
    }

    public void removeAll() {
        this.cacheAdmin.flushAll();
    }

    public void dispose() {
        super.dispose();
        this.cacheAdmin.destroy();
    }

    public void cacheEntryAdded(CacheEntryEvent event) {
        this.sendEntryAddedEvent(new OSCacheCacheEntryEvent(this, event));
    }

    public void cacheEntryFlushed(CacheEntryEvent event) {
        this.sendEntryRemovedEvent(new OSCacheCacheEntryEvent(this, event));
    }

    public void cacheEntryRemoved(CacheEntryEvent event) {
        this.sendEntryRemovedEvent(new OSCacheCacheEntryEvent(this, event));
    }

    public void cacheEntryUpdated(CacheEntryEvent event) {
        this.sendEntryModifiedEvent(new OSCacheCacheEntryEvent(this, event));
    }

    public void cacheGroupFlushed(CacheGroupEvent event) {
    }

    public void cachePatternFlushed(CachePatternEvent event) {
    }

    public void cacheFlushed(CachewideEvent event) {
    }
}

