/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.oscache.internal;

import com.opensymphony.oscache.base.algorithm.LRUCache;
import com.opensymphony.oscache.plugins.diskpersistence.DiskPersistenceListener;
import com.opensymphony.oscache.plugins.diskpersistence.HashDiskPersistenceListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.oscache.internal.PropertiesLoadingCacheException;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;
import org.xwiki.container.Container;

public class OSCacheCacheConfiguration
extends AbstractCacheConfigurationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSCacheCacheConfiguration.class);
    private static final String PROPS_PATH = "cache/oscache/";
    private static final String PROPS_EXT = ".properties";
    private static final String CONFOC_CACHE_PATH = "cache.path";
    private Properties oscacheConfiguration;
    private Container container;
    private int timeToLive = -1;
    private String name;

    public OSCacheCacheConfiguration(Container container, CacheConfiguration configuration, String defaultPropsId) {
        super(configuration, defaultPropsId);
        this.container = container;
        this.load();
    }

    public Properties getOSCacheProperties() {
        return this.oscacheConfiguration;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public String getName() {
        return this.name;
    }

    private void load() {
        this.oscacheConfiguration = this.getDefaultConfig();
        EntryEvictionConfiguration ec = null;
        try {
            this.oscacheConfiguration = this.getConfig(this.getCacheConfiguration().getConfigurationId());
        }
        catch (Exception e) {
            for (Map.Entry entry : this.getCacheConfiguration().entrySet()) {
                if (entry.getKey() != "eviction" || (ec = (EntryEvictionConfiguration)entry.getValue()).getAlgorithm() != EntryEvictionConfiguration.Algorithm.LRU) continue;
                this.oscacheConfiguration.setProperty("cache.algorithm", LRUCache.class.getName());
                if (!ec.containsKey((Object)"maxentries")) continue;
                this.oscacheConfiguration.setProperty("cache.capacity", ec.get((Object)"maxentries").toString());
            }
        }
        if (ec != null && ec.getTimeToLive() > 0) {
            this.timeToLive = ec.getTimeToLive();
        }
        this.name = this.getCacheConfiguration().getConfigurationId();
        if (this.name != null) {
            this.oscacheConfiguration.setProperty("cache.key", this.name);
        }
        this.completePersistanceListenerConfiguration();
    }

    private void completePersistanceListenerConfiguration() {
        String persistanceListener = this.oscacheConfiguration.getProperty("cache.persistence.class");
        if (persistanceListener != null && this.oscacheConfiguration.getProperty(CONFOC_CACHE_PATH) == null && (HashDiskPersistenceListener.class.getName().equals(persistanceListener) || DiskPersistenceListener.class.getName().equals(persistanceListener))) {
            this.oscacheConfiguration.setProperty(CONFOC_CACHE_PATH, this.createTempDir());
        }
    }

    private Properties getDefaultConfig() {
        Properties defaultConfig;
        block2: {
            defaultConfig = new Properties();
            try {
                this.loadConfig(defaultConfig, this.getDefaultPropsId());
            }
            catch (PropertiesLoadingCacheException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Could not load default cache properties", (Throwable)((Object)e));
            }
        }
        return defaultConfig;
    }

    private Properties getConfig(String propertiesId) throws PropertiesLoadingCacheException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading cache properties: " + propertiesId);
        }
        Properties props = this.getDefaultConfig();
        this.loadConfig(props, propertiesId);
        return props;
    }

    private void loadConfig(Properties props, String propertiesId) throws PropertiesLoadingCacheException {
        String propertiesFilename = propertiesId + PROPS_EXT;
        File file = new File(PROPS_PATH + propertiesFilename);
        InputStream is = null;
        try {
            is = file.exists() ? new FileInputStream(file) : this.container.getApplicationContext().getResourceAsStream("/WEB-INF/cache/oscache/" + propertiesFilename);
            if (is == null) {
                throw new PropertiesLoadingCacheException("Can't find any configuration file for" + propertiesId);
            }
            props.load(is);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Properties loaded: " + propertiesFilename);
            }
        }
        catch (Exception e) {
            throw new PropertiesLoadingCacheException("Error when trying to load configuration file for [" + propertiesId + "]");
        }
        finally {
            block13: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) break block13;
                        LOGGER.debug("Failed t close properties file", (Throwable)e);
                    }
                }
            }
        }
    }
}

