/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.tests;

import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;

public class CacheEntryListenerTest
implements CacheEntryListener<Object> {
    private CacheEntryEvent<Object> addedEvent;
    private CacheEntryEvent<Object> modifiedEvent;
    private CacheEntryEvent<Object> removedEvent;

    public CacheEntryEvent<Object> getAddedEvent() {
        return this.addedEvent;
    }

    public void reinitAddEvent() {
        this.addedEvent = null;
    }

    public CacheEntryEvent<Object> getModifiedEvent() {
        return this.modifiedEvent;
    }

    public void reinitModifiedEvent() {
        this.modifiedEvent = null;
    }

    public CacheEntryEvent<Object> getRemovedEvent() {
        return this.removedEvent;
    }

    public void reinitRemovedEvent() {
        this.removedEvent = null;
    }

    public void cacheEntryAdded(CacheEntryEvent<Object> event) {
        this.addedEvent = event;
    }

    public void cacheEntryModified(CacheEntryEvent<Object> event) {
        this.modifiedEvent = event;
    }

    public void cacheEntryRemoved(CacheEntryEvent<Object> event) {
        this.removedEvent = event;
    }

    public boolean waitForEntryEvent(EventType eventType) throws InterruptedException {
        EventWaiter eventWaiter = new EventWaiter(eventType);
        Thread thread = new Thread(eventWaiter);
        thread.start();
        thread.join(100000L);
        if (thread.isAlive()) {
            eventWaiter.stop();
            return false;
        }
        return true;
    }

    class EventWaiter
    implements Runnable {
        private boolean run = true;
        private EventType eventType;

        public EventWaiter(EventType eventType) {
            this.eventType = eventType;
        }

        void stop() {
            this.run = false;
        }

        @Override
        public void run() {
            CacheEntryEvent event;
            while (this.run && (event = this.eventType == EventType.ADD ? CacheEntryListenerTest.this.addedEvent : (this.eventType == EventType.MODIFY ? CacheEntryListenerTest.this.modifiedEvent : CacheEntryListenerTest.this.removedEvent)) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static enum EventType {
        ADD,
        MODIFY,
        REMOVE;

    }
}

