/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.calendar;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.plugin.calendar.CalendarData;
import com.xpn.xwiki.plugin.calendar.CalendarEvent;
import com.xpn.xwiki.plugin.calendar.CalendarParams;
import com.xpn.xwiki.plugin.calendar.CalendarPlugin;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;

public class CalendarPluginApi
extends Api {
    private CalendarPlugin plugin;

    public CalendarPluginApi(CalendarPlugin plugin, XWikiContext context) {
        super(context);
        this.setPlugin(plugin);
    }

    public CalendarParams getCalendarParams(String month, String year) {
        return this.plugin.getCalendarParams(month, year, this.getXWikiContext());
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String user) throws XWikiException {
        return this.plugin.getHTMLCalendar(calendarParams, user, this.getXWikiContext());
    }

    public String getHTMLCalendar(CalendarParams calendarParams, Document doc, String user) throws XWikiException {
        return this.plugin.getHTMLCalendar(calendarParams, doc.getDocument(), user, this.getXWikiContext());
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String hql, String user) throws XWikiException {
        return this.plugin.getHTMLCalendar(calendarParams, hql, user, this.getXWikiContext());
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String hql, int nb) throws XWikiException {
        return this.plugin.getHTMLCalendar(calendarParams, hql, nb, this.getXWikiContext());
    }

    public String getHTMLCalendar(CalendarParams calendarParams, CalendarData calendarData) throws XWikiException {
        return this.plugin.getHTMLCalendar(calendarParams, calendarData, this.getXWikiContext());
    }

    public CalendarParams getCalendarParams() {
        return new CalendarParams();
    }

    public CalendarEvent getCalendarEvent() {
        return new CalendarEvent();
    }

    public CalendarEvent getCalendarEvent(java.util.Calendar dateStart, java.util.Calendar dateEnd, String user, String description) {
        return new CalendarEvent(dateStart, dateEnd, user, description);
    }

    public CalendarEvent getCalendarEvent(java.util.Date dateStart, java.util.Date dateEnd, String user, String description) {
        java.util.Calendar cdateStart = java.util.Calendar.getInstance();
        cdateStart.setTime(dateStart);
        java.util.Calendar cdateEnd = java.util.Calendar.getInstance();
        cdateEnd.setTime(dateEnd);
        return this.getCalendarEvent(cdateStart, cdateEnd, user, description);
    }

    public CalendarPlugin getPlugin() {
        if (this.hasProgrammingRights()) {
            return this.plugin;
        }
        return null;
    }

    public void setPlugin(CalendarPlugin plugin) {
        this.plugin = plugin;
    }

    public java.util.Calendar getCalendar(long time) {
        Locale locale = this.getXWikiContext().getResponse().getLocale();
        if (locale == null) {
            locale = new Locale("en");
        }
        java.util.Calendar cal = java.util.Calendar.getInstance(locale);
        cal.setTime(new java.util.Date(time));
        return cal;
    }

    public java.util.Calendar getCalendar() {
        Locale locale = this.getXWikiContext().getResponse().getLocale();
        if (locale == null) {
            locale = new Locale("en");
        }
        java.util.Calendar cal = java.util.Calendar.getInstance(locale);
        cal.setTime(new java.util.Date());
        return cal;
    }

    public Calendar getCalendar(String surl) throws ParserException, IOException {
        Calendar calendar = this.plugin.getCalendar(surl, this.getXWikiContext());
        return calendar;
    }

    public Calendar getCalendar(String surl, String username, String password) throws ParserException, IOException {
        Calendar calendar = this.plugin.getCalendar(surl, username, password, this.getXWikiContext());
        return calendar;
    }

    public CalendarData getCalendarEvents(String surl, String user) throws ParserException, IOException {
        Calendar calendar = this.plugin.getCalendar(surl, this.getXWikiContext());
        return this.fromCalendar(calendar, user);
    }

    public CalendarData getCalendarEvents(String surl, String user, String username, String password) throws ParserException, IOException {
        Calendar calendar = this.plugin.getCalendar(surl, username, password, this.getXWikiContext());
        return this.fromCalendar(calendar, user);
    }

    public CalendarData fromCalendar(Calendar calendar, String user) {
        CalendarData data = new CalendarData();
        for (Component component : calendar.getComponents()) {
            if (!(component instanceof VEvent)) continue;
            VEvent event = (VEvent)component;
            java.util.Calendar sdate = java.util.Calendar.getInstance();
            sdate.setTime((java.util.Date)event.getStartDate().getDate());
            java.util.Calendar edate = java.util.Calendar.getInstance();
            edate.setTime((java.util.Date)event.getEndDate().getDate());
            PropertyList prop = event.getProperties();
            Property summary = prop.getProperty("SUMMARY");
            StringBuffer newsummary = new StringBuffer(summary != null ? summary.getValue() : "");
            if (sdate.get(10) != 0 || sdate.get(12) != 0 || edate.get(10) != 0 || edate.get(12) != 0) {
                SimpleDateFormat sformat = new SimpleDateFormat("HH:mm");
                newsummary.append(" ");
                newsummary.append(sformat.format(sdate.getTime()));
                newsummary.append("-");
                newsummary.append(sformat.format(edate.getTime()));
            } else {
                edate.add(10, -24);
            }
            CalendarEvent cevent = new CalendarEvent(sdate, edate, user, newsummary.toString());
            data.addCalendarData(cevent);
        }
        return data;
    }

    public Calendar toCalendar(CalendarData data) {
        Iterator it = data.getCalendarData().iterator();
        Calendar cal = new Calendar();
        while (it.hasNext()) {
            CalendarEvent cevent = (CalendarEvent)it.next();
            java.util.Calendar datestart = cevent.getDateStart();
            java.util.Calendar dateend = cevent.getDateEnd();
            VEvent vevent = new VEvent();
            float duration = (dateend.getTimeInMillis() - datestart.getTimeInMillis()) / 1000L / 60L / 60L / 24L;
            if (duration >= 1.0f) {
                dateend = (java.util.Calendar)datestart.clone();
                dateend.add(10, 24);
                RRule rule = new RRule(new Recur("DAILY", Math.round(duration)));
                vevent.getProperties().add((Property)rule);
            }
            DtStart dtstart = new DtStart(new Date(cevent.getDateStart().getTime()));
            DtEnd dtend = new DtEnd(new Date(cevent.getDateEnd().getTime()));
            dtstart.getParameters().add((Parameter)Value.DATE);
            dtend.getParameters().add((Parameter)Value.DATE);
            vevent.getProperties().add((Property)dtstart);
            vevent.getProperties().add((Property)dtend);
            vevent.getProperties().add((Property)new Summary(cevent.getDescription()));
            cal.getComponents().add((Component)vevent);
        }
        return cal;
    }

    public String toICal(CalendarData data) {
        return this.toCalendar(data).toString();
    }

    public String toICal(Document doc, String user) throws XWikiException {
        CalendarData cData = new CalendarData(doc.getDocument(), user, this.getXWikiContext());
        return this.toICal(cData);
    }

    public String toICal(String user) throws XWikiException {
        CalendarData cData = new CalendarData(this.getXWikiContext().getDoc(), user, this.getXWikiContext());
        return this.toICal(cData);
    }

    public String getHTMLCalendarFromICal(CalendarParams calendarParams, String surl, String user) throws XWikiException, ParserException, IOException {
        return this.plugin.getHTMLCalendar(calendarParams, this.getCalendarEvents(surl, user), this.getXWikiContext());
    }

    public String getHTMLCalendarFromICal(CalendarParams calendarParams, String surl, String user, String username, String password) throws XWikiException, ParserException, IOException {
        return this.plugin.getHTMLCalendar(calendarParams, this.getCalendarEvents(surl, user, username, password), this.getXWikiContext());
    }
}

