/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.script;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.captcha.Captcha;
import org.xwiki.captcha.CaptchaConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.script.internal.safe.ScriptSafeProvider;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Unstable
@Component
@Named(value="captcha")
@Singleton
public class CaptchaScriptService
implements ScriptService {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private CaptchaConfiguration configuration;
    @Inject
    private ScriptSafeProvider<Captcha> safeProvider;
    @Inject
    private Logger logger;

    public List<String> getCaptchaNames() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            names = new ArrayList(this.componentManager.getInstanceMap(Captcha.class).keySet());
        }
        catch (Exception e) {
            this.logger.error("Failed to get list of captcha names", (Throwable)e);
        }
        return names;
    }

    public Captcha get(String captchaName) {
        try {
            return (Captcha)this.safeProvider.get((Object)this.getCaptcha(captchaName));
        }
        catch (ComponentLookupException e) {
            this.logger.warn("No CAPTCHA implementation named [{}] was found", (Object)captchaName);
        }
        catch (Exception e) {
            this.logger.error("Failed to get CAPTCHA implementation with name [{}]", (Object)captchaName, (Object)e);
        }
        return null;
    }

    public String getDefaultCaptchaName() {
        return this.configuration.getDefaultName();
    }

    public Captcha getDefault() {
        return this.get(this.getDefaultCaptchaName());
    }

    private Captcha getCaptcha(String captchaName) throws ComponentLookupException {
        return (Captcha)this.componentManager.getInstance(Captcha.class, captchaName);
    }
}

