/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.captcha.Captcha;
import org.xwiki.captcha.CaptchaException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.script.ScriptContextManager;

public abstract class AbstractCaptcha
implements Captcha {
    private static final String CAPTCHA_PARAMETERS_BINDING = "captchaParameters";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private ScriptContextManager scriptContextManager;

    protected abstract LocalDocumentReference getDisplayerDocumentReference();

    protected abstract LocalDocumentReference getConfigurationDocumentReference();

    protected abstract LocalDocumentReference getConfigurationClassReference();

    protected abstract Map<String, Object> getDefaultParameters();

    protected abstract boolean validate(Map<String, Object> var1) throws Exception;

    protected Logger getLogger() {
        return this.logger;
    }

    protected ScriptContextManager getScriptContextManager() {
        return this.scriptContextManager;
    }

    public String display() throws CaptchaException {
        return this.display(null);
    }

    public String display(Map<String, Object> parameters) throws CaptchaException {
        String result = null;
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWiki xwiki = context.getWiki();
            Map<String, Object> captchaParameters = this.getMergedParameters(parameters);
            this.scriptContextManager.getCurrentScriptContext().setAttribute(CAPTCHA_PARAMETERS_BINDING, captchaParameters, 100);
            XWikiDocument displayerDocument = xwiki.getDocument((EntityReference)this.getDisplayerDocumentReference(), context);
            result = displayerDocument.getRenderedContent(context);
        }
        catch (Exception e) {
            throw new CaptchaException("Failed to display CAPTCHA", (Throwable)e);
        }
        return result;
    }

    public boolean isValid() throws CaptchaException {
        return this.isValid(null);
    }

    public boolean isValid(Map<String, Object> parameters) throws CaptchaException {
        Boolean result = false;
        try {
            Map<String, Object> captchaParameters = this.getMergedParameters(parameters);
            result = this.validate(captchaParameters);
        }
        catch (Exception e) {
            throw new CaptchaException("Failed to validate CAPTCHA answer", (Throwable)e);
        }
        return result;
    }

    protected Map<String, Object> getMergedParameters(Map<String, Object> parameters) {
        Map<String, Object> captchaParameters = this.getConfiguredParameters();
        if (parameters != null && parameters.size() > 0) {
            captchaParameters.putAll(parameters);
        }
        return captchaParameters;
    }

    protected Map<String, Object> getConfiguredParameters() {
        XWikiContext context = this.getContext();
        XWiki xwiki = context.getWiki();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(this.getDefaultParameters());
        try {
            XWikiDocument configurationDoc = xwiki.getDocument((EntityReference)this.getConfigurationDocumentReference(), context);
            BaseObject configurationObj = configurationDoc.getXObject((EntityReference)this.getConfigurationClassReference());
            for (Object prop : configurationObj.getProperties()) {
                BaseProperty property = (BaseProperty)prop;
                Object value = property.getValue();
                if (value == null || value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) continue;
                parameters.put(property.getName(), value);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to read the configuration document [{}]. Using default values", (Object)this.getConfigurationDocumentReference(), (Object)e);
        }
        return parameters;
    }

    protected XWikiContext getContext() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        return context;
    }
}

