/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.captcha.AbstractCaptcha;
import org.xwiki.captcha.CaptchaException;
import org.xwiki.captcha.internal.CaptchaServiceManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="jcaptcha")
@Singleton
public class JCaptchaCaptcha
extends AbstractCaptcha {
    private static final List<String> JCAPTCHA_SPACE_LIST = Arrays.asList("XWiki", "Captcha", "JCaptcha");
    private static final String ENGINE = "engine";
    private static final LocalDocumentReference CONFIGURATION_DOCUMENT_REFERENCE = new LocalDocumentReference(JCAPTCHA_SPACE_LIST, "Configuration");
    private static final LocalDocumentReference CONFIGURATION_CLASS_REFERENCE = new LocalDocumentReference(JCAPTCHA_SPACE_LIST, "ConfigurationClass");
    private static final LocalDocumentReference DISPLAYER_DOCUMENT_REFERENCE = new LocalDocumentReference(JCAPTCHA_SPACE_LIST, "Displayer");
    private static final Map<String, Object> DEFAULT_PARAMETERS = new HashMap<String, Object>();
    @Inject
    private CaptchaServiceManager captchaServiceManager;

    public JCaptchaCaptcha() {
        DEFAULT_PARAMETERS.put("type", "image");
        DEFAULT_PARAMETERS.put(ENGINE, "com.octo.captcha.engine.image.gimpy.DefaultGimpyEngine");
    }

    protected LocalDocumentReference getDisplayerDocumentReference() {
        return DISPLAYER_DOCUMENT_REFERENCE;
    }

    protected LocalDocumentReference getConfigurationDocumentReference() {
        return CONFIGURATION_DOCUMENT_REFERENCE;
    }

    protected LocalDocumentReference getConfigurationClassReference() {
        return CONFIGURATION_CLASS_REFERENCE;
    }

    protected Map<String, Object> getDefaultParameters() {
        return DEFAULT_PARAMETERS;
    }

    protected boolean validate(Map<String, Object> captchaParameters) throws CaptchaException, CaptchaServiceException {
        XWikiRequest request = this.getContext().getRequest();
        CaptchaService captchaService = this.captchaServiceManager.getCaptchaService((String)captchaParameters.get(ENGINE));
        String id = request.getSession().getId();
        String answer = request.getParameter("captchaAnswer");
        boolean result = captchaService.validateResponseForID(id, (Object)answer);
        return result;
    }
}

