/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import com.octo.captcha.component.sound.wordtosound.AbstractFreeTTSWordToSound;
import com.octo.captcha.module.web.image.ImageToJpegHelper;
import com.octo.captcha.module.web.sound.SoundToWavHelper;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.octo.captcha.service.sound.SoundCaptchaService;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.xwiki.captcha.internal.CaptchaServiceManager;
import org.xwiki.captcha.internal.JCaptchaResourceReference;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;

@Component
@Named(value="jcaptcha")
@Singleton
public class JCaptchaResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    private static final String FREETTS_PROPERTIES_KEY = "freetts.voices";
    private static final String TYPE_IMAGE = "image";
    private static final String TYPE_SOUND = "sound";
    private static final String TYPE_TEXT = "text";
    @Inject
    private CaptchaServiceManager captchaServiceManager;
    @Inject
    private Container container;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(JCaptchaResourceReference.TYPE);
    }

    /*
     * Unable to fully structure code
     */
    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        try {
            request = ((ServletRequest)this.container.getRequest()).getHttpServletRequest();
            response = ((ServletResponse)this.container.getResponse()).getHttpServletResponse();
            jCaptchaResourceReference = (JCaptchaResourceReference)reference;
            if (System.getProperty("freetts.voices") == null) {
                System.setProperty("freetts.voices", AbstractFreeTTSWordToSound.defaultVoicePackage);
            }
            captchaService = this.captchaServiceManager.getCaptchaService(jCaptchaResourceReference.getEngine());
            type = jCaptchaResourceReference.getCaptchaType();
            id = request.getSession().getId();
            locale = request.getLocale();
            if (type == null) {
                throw new IllegalArgumentException("Missing [type] parameter");
            }
            var10_11 = type;
            var11_12 = -1;
            switch (var10_11.hashCode()) {
                case 100313435: {
                    if (!var10_11.equals("image")) break;
                    var11_12 = 0;
                    break;
                }
                case 109627663: {
                    if (!var10_11.equals("sound")) break;
                    var11_12 = 1;
                    break;
                }
                case 3556653: {
                    if (!var10_11.equals("text")) break;
                    var11_12 = 2;
                }
            }
            switch (var11_12) {
                case 0: {
                    ImageToJpegHelper.flushNewCaptchaToResponse((HttpServletRequest)request, (HttpServletResponse)response, null, (ImageCaptchaService)((ImageCaptchaService)captchaService), (String)id, (Locale)locale);
                    break;
                }
                case 1: {
                    SoundToWavHelper.flushNewCaptchaToResponse((HttpServletRequest)request, (HttpServletResponse)response, null, (SoundCaptchaService)((SoundCaptchaService)captchaService), (String)id, (Locale)locale);
                    break;
                }
                case 2: {
                    response.setContentType("text/plain");
                    response.setCharacterEncoding("UTF-8");
                    response.setHeader("Cache-Control", "no-store");
                    response.setHeader("Pragma", "no-cache");
                    response.setDateHeader("Expires", 0L);
                    challenge = (String)captchaService.getChallengeForID(id, locale);
                    responseOutput = response.getOutputStream();
                    var14_15 = null;
                    IOUtils.write((String)challenge, (OutputStream)responseOutput, (Charset)Charset.defaultCharset());
                    if (responseOutput == null) break;
                    if (var14_15 == null) ** GOTO lbl54
                    try {
                        responseOutput.close();
                    }
                    catch (Throwable var15_16) {
                        var14_15.addSuppressed(var15_16);
                    }
                    break;
lbl54:
                    // 1 sources

                    responseOutput.close();
                    break;
                    catch (Throwable var15_17) {
                        try {
                            var14_15 = var15_17;
                            throw var15_17;
                        }
                        catch (Throwable var16_18) {
                            if (responseOutput != null) {
                                if (var14_15 != null) {
                                    try {
                                        responseOutput.close();
                                    }
                                    catch (Throwable var17_19) {
                                        var14_15.addSuppressed(var17_19);
                                    }
                                } else {
                                    responseOutput.close();
                                }
                            }
                            throw var16_18;
                        }
                    }
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported value [%s] for the [type] parameter", new Object[]{type}));
                }
            }
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to handle resource [%s]", new Object[]{JCaptchaResourceReference.TYPE}), (Throwable)e);
        }
        chain.handleNext(reference);
    }
}

