/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.captcha.CaptchaVerifier;
import org.xwiki.captcha.CaptchaVerifierNotFoundException;
import org.xwiki.captcha.XWikiCaptchaService;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component
@Singleton
public class DefaultXWikiCaptchaService
implements XWikiCaptchaService {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Override
    public CaptchaVerifier getCaptchaVerifier(String captchaName) throws CaptchaVerifierNotFoundException {
        CaptchaVerifier captchaVerifier;
        try {
            captchaVerifier = (CaptchaVerifier)this.componentManager.lookup(CaptchaVerifier.class, captchaName);
        }
        catch (ComponentLookupException e) {
            throw new CaptchaVerifierNotFoundException("The CaptchaVerifier " + captchaName + " could not be found, try listCaptchaNames()" + " for a list of registered CaptchaVerifiers.");
        }
        return captchaVerifier;
    }

    @Override
    public List<String> listCaptchaNames() {
        ArrayList<String> captchaNames = new ArrayList<String>();
        try {
            captchaNames.addAll(this.componentManager.lookupMap(CaptchaVerifier.class).keySet());
        }
        catch (ComponentLookupException e) {
            this.logger.error("Couldn't get list of CaptchaVerifier names " + e.getMessage());
        }
        return captchaNames;
    }

    @Override
    @Deprecated
    public boolean isEnabled() {
        return true;
    }
}

