/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.chart.ChartGenerator;
import org.xwiki.chart.ChartGeneratorException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.internal.macro.chart.ChartImageWriter;
import org.xwiki.rendering.internal.macro.chart.ImageId;
import org.xwiki.rendering.internal.macro.chart.source.DataSource;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.chart.ChartMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="chart")
@Singleton
public class ChartMacro
extends AbstractMacro<ChartMacroParameters> {
    private static final String DESCRIPTION = "Displays a graphical chart generated from miscellaneous data sources";
    private static final String CONTENT_DESCRIPTION = "Input data for the chart macro (Ex. for 'inline' source mode)";
    @Inject
    private ChartGenerator chartGenerator;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="tmp")
    private ChartImageWriter imageWriter;

    public ChartMacro() {
        super("Chart", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false), ChartMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(ChartMacroParameters macroParams, String content, MacroTransformationContext context) throws MacroExecutionException {
        this.generateChart(macroParams, content, context);
        String imageLocation = this.imageWriter.getURL(new ImageId(macroParams));
        String title = macroParams.getTitle();
        ResourceReference reference = new ResourceReference(imageLocation, ResourceType.URL);
        ImageBlock imageBlock = new ImageBlock(new ResourceReference(imageLocation, ResourceType.URL), true);
        imageBlock.setParameter("alt", title);
        LinkBlock linkBlock = new LinkBlock(Collections.singletonList(imageBlock), reference, true);
        linkBlock.setParameter("title", title);
        Object resultBlock = context.isInline() ? linkBlock : new ParagraphBlock(Collections.singletonList(linkBlock));
        return Collections.singletonList(resultBlock);
    }

    private void generateChart(ChartMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        DataSource dataSource;
        String source = this.computeSource(parameters.getSource(), content);
        try {
            dataSource = (DataSource)this.componentManager.getInstance(DataSource.class, source);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Invalid source parameter [%s]", parameters.getSource()), (Throwable)e);
        }
        Map<String, String> sourceParameters = this.getSourceParameters(parameters, source);
        dataSource.buildDataset(content, sourceParameters, context);
        try {
            this.imageWriter.writeImage(new ImageId(parameters), this.chartGenerator.generate(dataSource.getChartModel(), sourceParameters));
        }
        catch (ChartGeneratorException e) {
            throw new MacroExecutionException("Error while rendering chart", (Throwable)e);
        }
    }

    private String computeSource(String userDefinedSource, String content) {
        String source = userDefinedSource;
        if (source == null) {
            source = StringUtils.isEmpty((CharSequence)content) ? "xdom" : "inline";
        }
        return source;
    }

    private Map<String, String> getSourceParameters(ChartMacroParameters chartMacroParameters, String sourceHint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("title", chartMacroParameters.getTitle());
        parameters.put("width", String.valueOf(chartMacroParameters.getWidth()));
        parameters.put("height", String.valueOf(chartMacroParameters.getHeight()));
        parameters.put("type", chartMacroParameters.getType());
        parameters.put("source", sourceHint);
        parameters.put("params", chartMacroParameters.getParams());
        String sourceParameters = chartMacroParameters.getParams();
        if (null != sourceParameters) {
            String[] segments;
            for (String segment : segments = sourceParameters.split(";")) {
                String[] keyValue = segment.split(":", 2);
                String key = StringUtils.trim((String)keyValue[0]);
                if (keyValue.length == 2) {
                    parameters.put(key, keyValue[1]);
                    continue;
                }
                parameters.put(key, null);
            }
        }
        return parameters;
    }
}

