/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.source;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.chart.model.ChartModel;
import org.xwiki.chart.model.DefaultChartModel;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.chart.ChartDataSource;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public abstract class AbstractTableBlockDataSource
implements ChartDataSource {
    private static final int LETTER_RANGE_LENGTH = 26;
    private static final String RANGE_PARAM = "range";
    private static final String RANGE_SEPERATOR = "-";
    private static final String RANGE_COLUMN_REGEX = "[A-Z]{1,2}";
    private static final String RANGE_ROW_REGEX = "[0-9]+";
    private static final String RANGE_CELL_REGEX = "[A-Z]{1,2}[0-9]+";
    private static final Pattern RANGE_SEPERATOR_PATTERN = Pattern.compile("-");
    private static final Pattern RANGE_COLUMN_PATTERN = Pattern.compile("[A-Z]{1,2}");
    private static final Pattern RANGE_PATTERN = Pattern.compile("^[A-Z]{1,2}[0-9]+-[A-Z]{1,2}[0-9]+");
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;

    public static int getColumnNumberFromIdentifier(String identifier) {
        char j;
        int i = 0;
        int result = -1;
        while (i < identifier.length() && Character.isUpperCase(j = identifier.charAt(i++))) {
            result = (result + 1) * 26 + j - 65;
        }
        return result;
    }

    @Override
    public ChartModel buildModel(String macroContent, Map<String, String> macroParameters) throws MacroExecutionException {
        this.populateSourceParameters(macroParameters);
        TableBlock tableBlock = this.getTableBlock(macroContent, macroParameters);
        int[] dataRange = this.getDataRange(tableBlock, macroContent, macroParameters);
        int startRow = dataRange[0];
        int startColumn = dataRange[1];
        int endRow = dataRange[2];
        int endColumn = dataRange[3];
        Number[][] data = new Number[endRow - startRow + 1][endColumn - startColumn + 1];
        for (int i = startRow; i <= endRow; ++i) {
            if (i < tableBlock.getChildren().size()) {
                TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(i);
                for (int j = startColumn; j <= endColumn; ++j) {
                    if (j >= tableRow.getChildren().size()) {
                        throw new MacroExecutionException("Data range (columns) overflow.");
                    }
                    data[i - startRow][j - startColumn] = this.cellContentAsNumber((TableCellBlock)tableRow.getChildren().get(j));
                }
                continue;
            }
            throw new MacroExecutionException("Data range (rows) overflow.");
        }
        String[] rowHeaders = null;
        if (startColumn > 0) {
            rowHeaders = new String[endRow - startRow + 1];
            for (int i = startRow; i <= endRow; ++i) {
                TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(i);
                rowHeaders[i - startRow] = this.cellContentAsString((TableCellBlock)tableRow.getChildren().get(startColumn - 1));
            }
        }
        String[] columnHeaders = null;
        if (startRow > 0) {
            columnHeaders = new String[endColumn - startColumn + 1];
            TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(startRow - 1);
            for (int j = startColumn; j <= endColumn; ++j) {
                columnHeaders[j - startColumn] = this.cellContentAsString((TableCellBlock)tableRow.getChildren().get(j));
            }
        }
        return new DefaultChartModel(data, rowHeaders, columnHeaders);
    }

    private Number cellContentAsNumber(TableCellBlock cell) throws MacroExecutionException {
        String stringContent = this.cellContentAsString(cell);
        try {
            return Double.valueOf(stringContent);
        }
        catch (NumberFormatException ex) {
            throw new MacroExecutionException(String.format("Invalid number: [%s].", stringContent));
        }
    }

    private String cellContentAsString(TableCellBlock cell) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextBlockRenderer.render((Collection)cell.getChildren(), (WikiPrinter)printer);
        return printer.toString();
    }

    protected void populateSourceParameters(Map<String, String> macroParameters) {
        String extraParams = macroParameters.get("params");
        if (null != extraParams) {
            String[] segments;
            for (String segment : segments = extraParams.split(";")) {
                String[] keyValue = segment.split(":");
                if (keyValue.length != 2) continue;
                macroParameters.put(keyValue[0], keyValue[1]);
            }
        }
    }

    protected int[] getDataRange(TableBlock tableBlock, String macroContent, Map<String, String> macroParameters) throws MacroExecutionException {
        TableRowBlock firstRow;
        int columnCount;
        String range = macroParameters.get(RANGE_PARAM);
        if (range != null) {
            if (!RANGE_PATTERN.matcher(range).matches()) {
                throw new MacroExecutionException(String.format("Invalid range specification: [%s].", range));
            }
            String[] rangeSegments = RANGE_SEPERATOR_PATTERN.split(range);
            int startColumn = AbstractTableBlockDataSource.getColumnNumberFromIdentifier(rangeSegments[0]);
            int endColumn = AbstractTableBlockDataSource.getColumnNumberFromIdentifier(rangeSegments[1]);
            int startRow = Integer.parseInt(RANGE_COLUMN_PATTERN.matcher(rangeSegments[0]).replaceFirst("")) - 1;
            int endRow = Integer.parseInt(RANGE_COLUMN_PATTERN.matcher(rangeSegments[1]).replaceFirst("")) - 1;
            if (startColumn > endColumn || startRow > endRow) {
                throw new MacroExecutionException(String.format("Invalid data range: [%s].", range));
            }
            return new int[]{startRow, startColumn, endRow, endColumn};
        }
        int rowCount = tableBlock.getChildren().size();
        if (rowCount > 0 && (columnCount = (firstRow = (TableRowBlock)tableBlock.getChildren().get(0)).getChildren().size()) > 0) {
            return new int[]{0, 0, rowCount - 1, columnCount - 1};
        }
        throw new MacroExecutionException("Data table is incomplete.");
    }

    protected abstract TableBlock getTableBlock(String var1, Map<String, String> var2) throws MacroExecutionException;
}

