/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.charts.Chart;
import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.ChartImpl;
import com.xpn.xwiki.plugin.charts.ChartingPluginApi;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.plots.PlotFactory;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import com.xpn.xwiki.plugin.charts.source.MainDataSourceFactory;
import com.xpn.xwiki.plugin.svg.SVGPlugin;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiResponse;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletOutputStream;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xwiki.environment.Environment;

public class ChartingPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    private Environment environment = (Environment)Utils.getComponent(Environment.class);
    private static Logger LOGGER = LoggerFactory.getLogger(ChartingPlugin.class);
    private File tempDir;

    public ChartingPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public void init(XWikiContext context) {
        super.init(context);
        LOGGER.info("Charting Plugin - init");
        File dir = this.environment.getTemporaryDirectory();
        this.tempDir = new File(dir, "charts");
        try {
            this.tempDir.mkdirs();
        }
        catch (Exception e1) {
            LOGGER.warn("Could not create charts temporary directory: " + this.tempDir, (Throwable)e1);
            dir = new File(context.getWiki().Param("xwiki.upload.tempdir"));
            try {
                this.tempDir = new File(dir, "charts");
            }
            catch (Exception e2) {
                LOGGER.error("Could not create charts temporary directory: " + this.tempDir, (Throwable)e2);
            }
        }
    }

    public String getName() {
        return "charting";
    }

    public Chart generateChart(ChartParams params, XWikiContext context) throws GenerateException {
        try {
            Plot plot;
            DataSource dataSource = MainDataSourceFactory.getInstance().create(params.getMap("source"), context);
            String type = params.getString("type");
            try {
                String factoryClassName = ChartingPlugin.class.getPackage().getName() + ".plots." + Character.toUpperCase(type.charAt(0)) + type.toLowerCase().substring(1) + "PlotFactory";
                Class<?> factoryClass = Class.forName(factoryClassName);
                Method method = factoryClass.getMethod("getInstance", new Class[0]);
                PlotFactory factory = (PlotFactory)method.invoke(null, new Object[0]);
                plot = factory.create(dataSource, params);
            }
            catch (InvocationTargetException e) {
                throw new GenerateException(e.getTargetException());
            }
            catch (Throwable e) {
                throw new GenerateException(e);
            }
            ChartCustomizer.customizePlot(plot, params);
            JFreeChart jfchart = new JFreeChart(plot);
            ChartCustomizer.customizeChart(jfchart, params);
            return this.generatePngChart(jfchart, params, context);
        }
        catch (IOException ioe) {
            throw new GenerateException(ioe);
        }
        catch (DataSourceException dse) {
            throw new GenerateException(dse);
        }
    }

    private Chart generateSvgChart(JFreeChart jfchart, ChartParams params, XWikiContext context) throws IOException, GenerateException {
        String imageURL;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, params.getInteger("width").intValue(), params.getInteger("height").intValue());
        jfchart.draw((Graphics2D)svgGenerator, (Rectangle2D)rect);
        boolean useCSS = false;
        StringWriter swriter = new StringWriter();
        svgGenerator.stream((Writer)swriter, useCSS);
        String svgText = swriter.toString();
        String pageURL = null;
        SVGPlugin svgPlugin = (SVGPlugin)context.getWiki().getPlugin("svg", context);
        if (svgPlugin == null) {
            throw new GenerateException("SVGPlugin not loaded");
        }
        try {
            imageURL = svgPlugin.getSVGImageURL(svgText, params.getInteger("height").intValue(), params.getInteger("width").intValue(), context);
        }
        catch (SVGConverterException sce) {
            throw new GenerateException(sce);
        }
        return new ChartImpl(params, imageURL, pageURL);
    }

    private Chart generatePngChart(JFreeChart jfchart, ChartParams params, XWikiContext context) throws IOException, GenerateException {
        String imageURL;
        File file = this.getTempFile(params.hashCode(), "png");
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jfchart, (int)params.getInteger("width"), (int)params.getInteger("height"));
        String pageURL = imageURL = context.getDoc().getAttachmentURL(file.getName(), "charting", context);
        return new ChartImpl(params, imageURL, pageURL);
    }

    public void outputFile(String filename, XWikiContext context) throws IOException {
        File ofile = this.getTempFile(filename);
        byte[] bytes = this.readFile(ofile);
        XWikiResponse response = context.getResponse();
        context.setFinished(true);
        response.setDateHeader("Last-Modified", ofile.lastModified());
        response.setContentLength(bytes.length);
        response.setContentType(context.getEngineContext().getMimeType(filename));
        ServletOutputStream os = response.getOutputStream();
        os.write(bytes);
    }

    public byte[] readFile(File ofile) throws IOException {
        FileInputStream fis = new FileInputStream(ofile);
        byte[] result = new byte[(int)ofile.length()];
        fis.read(result);
        return result;
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new ChartingPluginApi((ChartingPlugin)plugin, context);
    }

    private File getTempFile(int hashcode, String extension) {
        return this.getTempFile(hashcode + "." + extension);
    }

    private File getTempFile(String filename) {
        return new File(this.tempDir, filename);
    }
}

