/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.MissingArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.ChartParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractChartParam
implements ChartParam {
    protected String name;
    protected boolean optional;
    public static final String MAP_SEPARATOR = ";";
    public static final String MAP_ASSIGNMENT = ":";
    public static final String LIST_SEPARATOR = ",";

    public AbstractChartParam(String name) {
        this(name, true);
    }

    public AbstractChartParam(String name, boolean optional) {
        this.name = name;
        this.optional = optional;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public abstract Class getType();

    @Override
    public abstract Object convert(String var1) throws ParamException;

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ChartParam) {
            return this.getName().equals(((ChartParam)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected String getStringArg(Map map, String name) throws MissingArgumentException {
        String value = (String)map.get(name);
        if (value != null) {
            return value;
        }
        throw new MissingArgumentException("Invalid value for the parameter " + this.getName() + ": Argument " + name + " is mandatory.");
    }

    protected String getStringOptionalArg(Map map, String name) {
        return (String)map.get(name);
    }

    protected int getIntArg(Map map, String name) throws MissingArgumentException, InvalidArgumentException {
        String value = this.getStringArg(map, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": Non-integer value for the " + name + " argument.");
        }
    }

    protected float getFloatArg(Map map, String name) throws MissingArgumentException, InvalidArgumentException {
        String value = this.getStringArg(map, name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": Non-float value for the " + name + " argument.");
        }
    }

    protected double getDoubleArg(Map map, String name) throws MissingArgumentException, InvalidArgumentException {
        String value = this.getStringArg(map, name);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": Non-double value for the " + name + " argument.");
        }
    }

    protected Object getChoiceArg(Map map, String name, Map choices) throws MissingArgumentException, InvalidArgumentException {
        String value = this.getStringArg(map, name);
        Object obj = choices.get(value);
        if (obj != null) {
            return obj;
        }
        throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": The accepted values for the " + name + "argument are " + choices.keySet() + "; encountered: " + value);
    }

    protected List getListArg(Map map, String name) throws MissingArgumentException {
        return this.parseList(this.getStringArg(map, name));
    }

    protected Map parseMap(String value) throws InvalidArgumentException {
        String[] args = value.split(MAP_SEPARATOR);
        if (args.length == 0 || args.length == 1 && args[0].length() == 0) {
            return new HashMap(0);
        }
        HashMap<String, String> result = new HashMap<String, String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String[] split = args[i].split(MAP_ASSIGNMENT);
            if (split.length != 2) {
                throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": name" + MAP_ASSIGNMENT + "value \"" + MAP_SEPARATOR + "\"-separated list expected");
            }
            result.put(split[0].trim(), split[1].trim());
        }
        return result;
    }

    protected Map parseMap(String value, int expectedTokenCount) throws InvalidArgumentException {
        Map result = this.parseMap(value);
        if (result.size() != expectedTokenCount) {
            throw new InvalidArgumentException("Invalid number of arguments given to the " + this.getName() + " parameter; expected:" + expectedTokenCount);
        }
        return result;
    }

    protected List parseList(String value) {
        String[] args = value.split(LIST_SEPARATOR);
        if (args.length == 0 || args.length == 1 && args[0].length() == 0) {
            return new ArrayList(0);
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            result.add(args[i].trim());
        }
        return result;
    }

    protected List toFloatList(List list) throws InvalidArgumentException {
        ArrayList<Float> result = new ArrayList<Float>(list.size());
        for (String value : list) {
            try {
                result.add(Float.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": Non-float value for " + this.name);
            }
        }
        return result;
    }

    protected float[] toFloatArray(List list) throws InvalidArgumentException {
        float[] result = new float[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            String value = (String)it.next();
            try {
                result[i] = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("Invalid value for the parameter " + this.getName() + ": Non-float value for " + this.name);
            }
            ++i;
        }
        return result;
    }
}

