/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.MissingArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.DateFormatChartParam;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.axis.DateTickUnit;

public class DateTickUnitChartParam
extends DateFormatChartParam {
    private Map unitChoice;

    public DateTickUnitChartParam(String name) {
        super(name);
        this.init();
    }

    public DateTickUnitChartParam(String name, boolean optional) {
        super(name, optional);
        this.init();
    }

    @Override
    public void init() {
        this.unitChoice = new HashMap();
        this.unitChoice.put("day", 2);
        this.unitChoice.put("hour", 3);
        this.unitChoice.put("millisecond", 6);
        this.unitChoice.put("minute", 4);
        this.unitChoice.put("month", 1);
        this.unitChoice.put("second", 5);
        this.unitChoice.put("year", 0);
    }

    @Override
    public Class getType() {
        return DateTickUnit.class;
    }

    @Override
    public Object convert(String value) throws ParamException {
        Map map = this.parseMap(value);
        int unit = (Integer)this.getChoiceArg(map, "unit", this.unitChoice);
        int count = this.getIntArg(map, "count");
        try {
            return new DateTickUnit(unit, count, (DateFormat)super.convert(value));
        }
        catch (MissingArgumentException e) {
            return new DateTickUnit(unit, count);
        }
    }
}

