/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.plots.CategoryPlotFactory;
import com.xpn.xwiki.plugin.charts.plots.PlotFactory;
import com.xpn.xwiki.plugin.charts.plots.XYPlotFactory;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import java.lang.reflect.Constructor;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class BarPlotFactory
implements PlotFactory {
    private static BarPlotFactory uniqueInstance = new BarPlotFactory();

    private BarPlotFactory() {
    }

    public static BarPlotFactory getInstance() {
        return uniqueInstance;
    }

    @Override
    public Plot create(DataSource dataSource, ChartParams params) throws GenerateException, DataSourceException {
        Class rendererClass = params.getClass("renderer");
        if (rendererClass == null || CategoryItemRenderer.class.isAssignableFrom(rendererClass)) {
            BarRenderer renderer;
            if (rendererClass != null) {
                try {
                    Constructor ctor = rendererClass.getConstructor(new Class[0]);
                    renderer = (CategoryItemRenderer)ctor.newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    throw new GenerateException(e);
                }
            } else {
                renderer = new BarRenderer();
            }
            return CategoryPlotFactory.getInstance().create(dataSource, (CategoryItemRenderer)renderer, params);
        }
        if (XYItemRenderer.class.isAssignableFrom(rendererClass)) {
            XYItemRenderer renderer;
            try {
                Constructor ctor = rendererClass.getConstructor(new Class[0]);
                renderer = (XYItemRenderer)ctor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new GenerateException(e);
            }
            ChartCustomizer.customizeXYItemRenderer(renderer, params);
            return XYPlotFactory.getInstance().create(dataSource, renderer, params);
        }
        throw new GenerateException("Incompatible renderer class: " + rendererClass);
    }
}

