/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.MissingMandatoryParamException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.BooleanChartParam;
import com.xpn.xwiki.plugin.charts.params.CategoryLabelPositionsChartParam;
import com.xpn.xwiki.plugin.charts.params.ChartParam;
import com.xpn.xwiki.plugin.charts.params.ColorChartParam;
import com.xpn.xwiki.plugin.charts.params.DateChartParam;
import com.xpn.xwiki.plugin.charts.params.DateFormatChartParam;
import com.xpn.xwiki.plugin.charts.params.DateTickMarkPositionChartParam;
import com.xpn.xwiki.plugin.charts.params.DateTickUnitChartParam;
import com.xpn.xwiki.plugin.charts.params.DoubleChartParam;
import com.xpn.xwiki.plugin.charts.params.FloatChartParam;
import com.xpn.xwiki.plugin.charts.params.FontChartParam;
import com.xpn.xwiki.plugin.charts.params.HorizontalAlignmentChartParam;
import com.xpn.xwiki.plugin.charts.params.IntegerChartParam;
import com.xpn.xwiki.plugin.charts.params.ListChartParam;
import com.xpn.xwiki.plugin.charts.params.MapChartParam;
import com.xpn.xwiki.plugin.charts.params.NumberFormatChartParam;
import com.xpn.xwiki.plugin.charts.params.NumberTickUnitChartParam;
import com.xpn.xwiki.plugin.charts.params.PlotOrientationChartParam;
import com.xpn.xwiki.plugin.charts.params.Point2DChartParam;
import com.xpn.xwiki.plugin.charts.params.RangeTypeChartParam;
import com.xpn.xwiki.plugin.charts.params.RectangleAnchorChartParam;
import com.xpn.xwiki.plugin.charts.params.RectangleEdgeChartParam;
import com.xpn.xwiki.plugin.charts.params.RectangleInsetsChartParam;
import com.xpn.xwiki.plugin.charts.params.RendererClassChartParam;
import com.xpn.xwiki.plugin.charts.params.ShapeChartParam;
import com.xpn.xwiki.plugin.charts.params.StringChartParam;
import com.xpn.xwiki.plugin.charts.params.StrokeChartParam;
import com.xpn.xwiki.plugin.charts.params.TimePeriodClassChartParam;
import com.xpn.xwiki.plugin.charts.params.VerticalAlignmentChartParam;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.RangeType;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;

public class ChartParams {
    private Map paramMap = new HashMap();
    private Map valueMap = new HashMap();
    private ChartParams parent;
    public static final String TYPE = "type";
    public static final String SOURCE = "source";
    public static final String SERIES = "series";
    public static final String HEIGHT = "height";
    public static final String WIDTH = "width";
    public static final String IMAGE_ATTRIBUTES = "image_attributes";
    public static final String LINK_ATTRIBUTES = "link_attributes";
    public static final String RENDERER = "renderer";
    public static final String RENDERER_COLOR = "renderer_color";
    public static final String RENDERER_STROKE = "renderer_stroke";
    public static final String RENDERER_SHAPE = "renderer_shape";
    public static final String RENDERER_FILL_COLOR = "renderer_fill_color";
    public static final String RENDERER_OUTLINE_COLOR = "renderer_outline_color";
    public static final String RENDERER_OUTLINE_STROKE = "renderer_outline_stroke";
    public static final String RENDERER_ITEM_LABEL_VISIBLE = "renderer_item_label_visible";
    public static final String RENDERER_ITEM_LABEL_COLOR = "renderer_item_label_color";
    public static final String RENDERER_ITEM_LABEL_FONT = "renderer_item_label_font";
    public static final String RENDERER_SERIES_VISIBLE = "series_visible";
    public static final String RENDERER_SERIES_VISIBLE_IN_LEGEND = "series_visible_in_legend";
    public static final String RENDERER_SERIES_COLORS = "series_colors";
    public static final String RENDERER_SERIES_STROKES = "series_strokes";
    public static final String RENDERER_SERIES_SHAPES = "series_shapes";
    public static final String RENDERER_SERIES_FILL_COLORS = "series_fill_colors";
    public static final String RENDERER_SERIES_OUTLINE_COLORS = "series_outline_colors";
    public static final String RENDERER_SERIES_OUTLINE_STROKES = "series_outline_strokes";
    public static final String RENDERER_SERIES_ITEM_LABEL_VISIBLES = "series_item_label_visibles";
    public static final String RENDERER_SERIES_ITEM_LABEL_COLORS = "series_item_label_colors";
    public static final String RENDERER_SERIES_ITEM_LABEL_FONTS = "series_item_label_fonts";
    public static final String BORDER_VISIBLE = "border_visible";
    public static final String BORDER_COLOR = "border_color";
    public static final String BORDER_STROKE = "border_stroke";
    public static final String TITLE_PREFIX = "title";
    public static final String SUBTITLE_PREFIX = "subtitle";
    public static final String TITLE_SUFFIX = "";
    public static final String TITLE_POSITION_SUFFIX = "_position";
    public static final String TITLE_HORIZONTAL_ALIGNMENT_SUFFIX = "_horizontal_alignment";
    public static final String TITLE_VERTICAL_ALIGNMENT_SUFFIX = "_vertical_alignment";
    public static final String TITLE_COLOR_SUFFIX = "_color";
    public static final String TITLE_BACKGROUND_COLOR_SUFFIX = "_background_color";
    public static final String TITLE_FONT_SUFFIX = "_font";
    public static final String TITLE_PADDING_SUFFIX = "_padding";
    public static final String TITLE_URL_SUFFIX = "_url";
    public static final String ANTI_ALIAS = "anti_alias";
    public static final String BACKGROUND_COLOR = "background_color";
    public static final String PLOT_BACKGROUND_COLOR = "plot_background_color";
    public static final String PLOT_BACKGROUND_ALPHA = "plot_background_alpha";
    public static final String PLOT_FOREGROUND_ALPHA = "plot_foreground_alpha";
    public static final String PLOT_INSERTS = "plot_inserts";
    public static final String PLOT_OUTLINE_COLOR = "plot_outline_color";
    public static final String PLOT_OUTLINE_STROKE = "plot_outline_stroke";
    public static final String XYPLOT_ORIENTATION = "plot_orientation";
    public static final String XYPLOT_QUADRANT_ORIGIN = "plot_quadrant_origin";
    public static final String XYPLOT_QUADRANT_COLORS = "plot_quadrant_colors";
    public static final String LEGEND_BACKGROUND_COLOR = "legend_background_color";
    public static final String LEGEND_ITEM_FONT = "legend_item_font";
    public static final String LEGEND_ITEM_LABEL_PADDING = "legend_item_label_padding";
    public static final String LEGEND_ITEM_GRAPHIC_ANCHOR = "legend_item_graphic_anchor";
    public static final String LEGEND_ITEM_GRAPHIC_EDGE = "legend_item_graphic_edge";
    public static final String LEGEND_ITEM_GRAPHIC_LOCATION = "legend_item_graphic_location";
    public static final String LEGEND_ITEM_GRAPHIC_PADDING = "legend_item_graphic_padding";
    public static final String AXIS_DOMAIN_PREFIX = "domain_axis_";
    public static final String AXIS_RANGE_PREFIX = "range_axis_";
    public static final String AXIS_VISIBLE_SUFIX = "visible";
    public static final String AXIS_LABEL_SUFFIX = "label";
    public static final String AXIS_LABEL_FONT_SUFFIX = "label_font";
    public static final String AXIS_LABEL_COLOR_SUFFIX = "label_color";
    public static final String AXIS_LABEL_INSERTS_SUFFIX = "label_inserts";
    public static final String AXIS_LINE_VISIBLE_SUFFIX = "line_visible";
    public static final String AXIS_LINE_COLOR_SUFFIX = "line_color";
    public static final String AXIS_LINE_STROKE_SUFFIX = "line_stroke";
    public static final String AXIS_TICK_LABEL_VISIBLE_SUFFIX = "tick_label_visible";
    public static final String AXIS_TICK_LABEL_FONT_SUFFIX = "tick_label_font";
    public static final String AXIS_TICK_LABEL_COLOR_SUFFIX = "tick_label_color";
    public static final String AXIS_TICK_LABEL_INSERTS_SUFFIX = "tick_label_inserts";
    public static final String AXIS_TICK_MARK_VISIBLE_SUFFIX = "tick_mark_visible";
    public static final String AXIS_TICK_MARK_INSIDE_LENGTH_SUFFIX = "tick_mark_inside_length";
    public static final String AXIS_TICK_MARK_OUTSIDE_LENGTH_SUFFIX = "tick_mark_outside_length";
    public static final String AXIS_TICK_MARK_COLOR_SUFFIX = "tick_mark_color";
    public static final String AXIS_TICK_MARK_STROKE_SUFFIX = "tick_mark_stroke";
    public static final String PLOTXY_AXIS_GRIDLINE_VISIBLE_SUFFIX = "gridline_visible";
    public static final String PLOTXY_AXIS_GRIDLINE_COLOR_SUFFIX = "gridline_color";
    public static final String PLOTXY_AXIS_GRIDLINE_STROKE_SUFFIX = "gridline_stroke";
    public static final String VALUE_AXIS_AUTO_RANGE_SUFFIX = "auto_range";
    public static final String VALUE_AXIS_AUTO_RANGE_MIN_SIZE_SUFFIX = "auto_range_min_size";
    public static final String VALUE_AXIS_AUTO_TICK_UNIT_SUFFIX = "auto_tick_unit";
    public static final String VALUE_AXIS_LOWER_BOUND_SUFFIX = "lower_bound";
    public static final String VALUE_AXIS_UPPER_BOUND_SUFFIX = "upper_bound";
    public static final String AXIS_LOWER_MARGIN_SUFFIX = "lower_margin";
    public static final String AXIS_UPPER_MARGIN_SUFFIX = "upper_margin";
    public static final String VALUE_AXIS_VERTICAL_TICK_LABELS_SUFFIX = "vertical_tick_labels";
    public static final String NUMBER_AXIS_AUTO_RANGE_INCLUDES_ZERO_SUFFIX = "auto_range_includes_zero";
    public static final String NUMBER_AXIS_AUTO_RANGE_STICKY_ZERO_SUFFIX = "auto_range_sticky_zero";
    public static final String NUMBER_AXIS_RANGE_TYPE_SUFFIX = "range_type";
    public static final String NUMBER_AXIS_NUMBER_TICK_UNIT_SUFFIX = "number_tick_unit";
    public static final String NUMBER_AXIS_NUMBER_FORMAT_OVERRIDE_SUFFIX = "number_format";
    public static final String DATE_AXIS_DATE_FORMAT_OVERRIDE_SUFFIX = "date_format_override";
    public static final String DATE_AXIS_UPPER_DATE_SUFFIX = "upper_date";
    public static final String DATE_AXIS_LOWER_DATE_SUFFIX = "lower_date";
    public static final String DATE_AXIS_DATE_TICK_MARK_POSITION_SUFFIX = "tick_mark_position";
    public static final String DATE_AXIS_DATE_TICK_UNIT_SUFFIX = "date_tick_unit";
    public static final String CATEGORY_AXIS_CATEGORY_MARGIN_SUFFIX = "category_margin";
    public static final String CATEGORY_AXIS_LABEL_POSITIONS_SUFFIX = "label_positions";
    public static final String CATEGORY_AXIS_LABEL_POSITION_OFFSET_SUFFIX = "label_position_offset";
    public static final String CATEGORY_AXIS_MAXIMUM_LABEL_LINES_SUFFIX = "maximum_label_lines";
    public static final String CATEGORY_AXIS_MAXIMUM_LABEL_WIDTH_RATIO_SUFFIX = "maximul_label_width_ratio";
    public static final String TIME_PERIOD_CLASS = "time_period";
    public static final String DATE_FORMAT = "date_format";

    public ChartParams() {
        this((ChartParams)null);
    }

    public ChartParams(Map map) throws ParamException {
        this(map, null, false);
    }

    public ChartParams(Map map, ChartParams parent) throws ParamException {
        this(map, parent, false);
    }

    public ChartParams(Map map, ChartParams parent, boolean discardNumbers) throws ParamException {
        this(parent);
        for (String name : map.keySet()) {
            String value = (String)map.get(name);
            if (discardNumbers) {
                try {
                    Integer.parseInt(name);
                }
                catch (NumberFormatException nfe) {
                    this.set(name.trim(), value.trim());
                }
                continue;
            }
            this.set(name.trim(), value.trim());
        }
    }

    public ChartParams(ChartParams parent) {
        this.parent = parent;
        this.addParam(new StringChartParam(TYPE, false));
        this.addParam(new MapChartParam(SOURCE, false));
        this.addParam(new IntegerChartParam(HEIGHT));
        this.addParam(new IntegerChartParam(WIDTH));
        this.addParam(new MapChartParam(LINK_ATTRIBUTES));
        this.addParam(new MapChartParam(IMAGE_ATTRIBUTES));
        this.addParam(new RendererClassChartParam(RENDERER));
        this.addParam(new ColorChartParam(RENDERER_COLOR));
        this.addParam(new StrokeChartParam(RENDERER_STROKE));
        this.addParam(new ShapeChartParam(RENDERER_SHAPE));
        this.addParam(new ColorChartParam(RENDERER_FILL_COLOR));
        this.addParam(new ColorChartParam(RENDERER_OUTLINE_COLOR));
        this.addParam(new StrokeChartParam(RENDERER_OUTLINE_STROKE));
        this.addParam(new BooleanChartParam(RENDERER_ITEM_LABEL_VISIBLE));
        this.addParam(new ColorChartParam(RENDERER_ITEM_LABEL_COLOR));
        this.addParam(new FontChartParam(RENDERER_ITEM_LABEL_FONT));
        this.addParam(new BooleanChartParam(RENDERER_SERIES_VISIBLE));
        this.addParam(new BooleanChartParam(RENDERER_SERIES_VISIBLE_IN_LEGEND));
        this.addParam(new ListChartParam(new ColorChartParam(RENDERER_SERIES_COLORS)));
        this.addParam(new ListChartParam(new StrokeChartParam(RENDERER_SERIES_STROKES)));
        this.addParam(new ListChartParam(new ShapeChartParam(RENDERER_SERIES_SHAPES)));
        this.addParam(new ListChartParam(new ColorChartParam(RENDERER_SERIES_FILL_COLORS)));
        this.addParam(new ListChartParam(new ColorChartParam(RENDERER_SERIES_OUTLINE_COLORS)));
        this.addParam(new ListChartParam(new StrokeChartParam(RENDERER_SERIES_OUTLINE_STROKES)));
        this.addParam(new ListChartParam(new BooleanChartParam(RENDERER_SERIES_ITEM_LABEL_VISIBLES)));
        this.addParam(new ListChartParam(new ColorChartParam(RENDERER_SERIES_ITEM_LABEL_COLORS)));
        this.addParam(new ListChartParam(new FontChartParam(RENDERER_SERIES_ITEM_LABEL_FONTS)));
        this.addParam(new BooleanChartParam(BORDER_VISIBLE));
        this.addParam(new ColorChartParam(BORDER_COLOR));
        this.addParam(new StrokeChartParam(BORDER_STROKE));
        this.addTitleParams(TITLE_PREFIX);
        this.addTitleParams(SUBTITLE_PREFIX);
        this.addParam(new BooleanChartParam(ANTI_ALIAS));
        this.addParam(new ColorChartParam(BACKGROUND_COLOR));
        this.addParam(new ColorChartParam(PLOT_BACKGROUND_COLOR));
        this.addParam(new FloatChartParam(PLOT_BACKGROUND_ALPHA));
        this.addParam(new FloatChartParam(PLOT_FOREGROUND_ALPHA));
        this.addParam(new RectangleInsetsChartParam(PLOT_INSERTS));
        this.addParam(new ColorChartParam(PLOT_OUTLINE_COLOR));
        this.addParam(new StrokeChartParam(PLOT_OUTLINE_STROKE));
        this.addParam(new PlotOrientationChartParam(XYPLOT_ORIENTATION));
        this.addParam(new Point2DChartParam(XYPLOT_QUADRANT_ORIGIN));
        this.addParam(new ListChartParam(new ColorChartParam(XYPLOT_QUADRANT_COLORS)));
        this.addParam(new ColorChartParam(LEGEND_BACKGROUND_COLOR));
        this.addParam(new FontChartParam(LEGEND_ITEM_FONT));
        this.addParam(new RectangleInsetsChartParam(LEGEND_ITEM_LABEL_PADDING));
        this.addParam(new RectangleAnchorChartParam(LEGEND_ITEM_GRAPHIC_ANCHOR));
        this.addParam(new RectangleEdgeChartParam(LEGEND_ITEM_GRAPHIC_EDGE));
        this.addParam(new RectangleAnchorChartParam(LEGEND_ITEM_GRAPHIC_LOCATION));
        this.addParam(new RectangleInsetsChartParam(LEGEND_ITEM_GRAPHIC_PADDING));
        this.addAxisParams(AXIS_DOMAIN_PREFIX);
        this.addAxisParams(AXIS_RANGE_PREFIX);
        this.addParam(new TimePeriodClassChartParam(TIME_PERIOD_CLASS));
        this.addParam(new DateFormatChartParam(DATE_FORMAT));
    }

    private void addAxisParams(String prefix) {
        this.addParam(new BooleanChartParam(prefix + AXIS_VISIBLE_SUFIX));
        this.addParam(new BooleanChartParam(prefix + AXIS_LINE_VISIBLE_SUFFIX));
        this.addParam(new ColorChartParam(prefix + AXIS_LINE_COLOR_SUFFIX));
        this.addParam(new StrokeChartParam(prefix + AXIS_LINE_STROKE_SUFFIX));
        this.addParam(new StringChartParam(prefix + AXIS_LABEL_SUFFIX));
        this.addParam(new FontChartParam(prefix + AXIS_LABEL_FONT_SUFFIX));
        this.addParam(new ColorChartParam(prefix + AXIS_LABEL_COLOR_SUFFIX));
        this.addParam(new RectangleInsetsChartParam(prefix + AXIS_LABEL_INSERTS_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + AXIS_TICK_LABEL_VISIBLE_SUFFIX));
        this.addParam(new FontChartParam(prefix + AXIS_TICK_LABEL_FONT_SUFFIX));
        this.addParam(new ColorChartParam(prefix + AXIS_TICK_LABEL_COLOR_SUFFIX));
        this.addParam(new RectangleInsetsChartParam(prefix + AXIS_TICK_LABEL_INSERTS_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + AXIS_TICK_MARK_VISIBLE_SUFFIX));
        this.addParam(new FloatChartParam(prefix + AXIS_TICK_MARK_INSIDE_LENGTH_SUFFIX));
        this.addParam(new FloatChartParam(prefix + AXIS_TICK_MARK_OUTSIDE_LENGTH_SUFFIX));
        this.addParam(new ColorChartParam(prefix + AXIS_TICK_MARK_COLOR_SUFFIX));
        this.addParam(new StrokeChartParam(prefix + AXIS_TICK_MARK_STROKE_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + PLOTXY_AXIS_GRIDLINE_VISIBLE_SUFFIX));
        this.addParam(new ColorChartParam(prefix + PLOTXY_AXIS_GRIDLINE_COLOR_SUFFIX));
        this.addParam(new StrokeChartParam(prefix + PLOTXY_AXIS_GRIDLINE_STROKE_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + VALUE_AXIS_AUTO_RANGE_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + VALUE_AXIS_AUTO_RANGE_MIN_SIZE_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + VALUE_AXIS_AUTO_TICK_UNIT_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + VALUE_AXIS_LOWER_BOUND_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + VALUE_AXIS_UPPER_BOUND_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + AXIS_LOWER_MARGIN_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + AXIS_UPPER_MARGIN_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + VALUE_AXIS_VERTICAL_TICK_LABELS_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + NUMBER_AXIS_AUTO_RANGE_INCLUDES_ZERO_SUFFIX));
        this.addParam(new BooleanChartParam(prefix + NUMBER_AXIS_AUTO_RANGE_STICKY_ZERO_SUFFIX));
        this.addParam(new RangeTypeChartParam(prefix + NUMBER_AXIS_RANGE_TYPE_SUFFIX));
        this.addParam(new NumberTickUnitChartParam(prefix + NUMBER_AXIS_NUMBER_TICK_UNIT_SUFFIX));
        this.addParam(new NumberFormatChartParam(prefix + NUMBER_AXIS_NUMBER_FORMAT_OVERRIDE_SUFFIX));
        this.addParam(new DateFormatChartParam(prefix + DATE_AXIS_DATE_FORMAT_OVERRIDE_SUFFIX));
        this.addParam(new DateChartParam(prefix + DATE_AXIS_LOWER_DATE_SUFFIX));
        this.addParam(new DateChartParam(prefix + DATE_AXIS_UPPER_DATE_SUFFIX));
        this.addParam(new DateTickMarkPositionChartParam(prefix + DATE_AXIS_DATE_TICK_MARK_POSITION_SUFFIX));
        this.addParam(new DateTickUnitChartParam(prefix + DATE_AXIS_DATE_TICK_UNIT_SUFFIX));
        this.addParam(new DoubleChartParam(prefix + CATEGORY_AXIS_CATEGORY_MARGIN_SUFFIX));
        this.addParam(new CategoryLabelPositionsChartParam(prefix + CATEGORY_AXIS_LABEL_POSITIONS_SUFFIX));
        this.addParam(new IntegerChartParam(prefix + CATEGORY_AXIS_LABEL_POSITION_OFFSET_SUFFIX));
        this.addParam(new IntegerChartParam(prefix + CATEGORY_AXIS_MAXIMUM_LABEL_LINES_SUFFIX));
        this.addParam(new FloatChartParam(prefix + CATEGORY_AXIS_MAXIMUM_LABEL_WIDTH_RATIO_SUFFIX));
    }

    private void addTitleParams(String prefix) {
        this.addParam(new StringChartParam(prefix + TITLE_SUFFIX));
        this.addParam(new ColorChartParam(prefix + TITLE_BACKGROUND_COLOR_SUFFIX));
        this.addParam(new RectangleEdgeChartParam(prefix + TITLE_POSITION_SUFFIX));
        this.addParam(new HorizontalAlignmentChartParam(prefix + TITLE_HORIZONTAL_ALIGNMENT_SUFFIX));
        this.addParam(new VerticalAlignmentChartParam(prefix + TITLE_VERTICAL_ALIGNMENT_SUFFIX));
        this.addParam(new ColorChartParam(prefix + TITLE_COLOR_SUFFIX));
        this.addParam(new FontChartParam(prefix + TITLE_FONT_SUFFIX));
        this.addParam(new RectangleInsetsChartParam(prefix + TITLE_PADDING_SUFFIX));
    }

    public void addParam(ChartParam param) {
        this.paramMap.put(param.getName(), param);
    }

    public void set(String name, String value) throws ParamException {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null) {
            this.valueMap.put(name, param.convert(value));
        } else {
            this.valueMap.put(name, value);
        }
    }

    protected void set(String name, Object obj) throws ParamException {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (obj != null && !param.getType().isInstance(obj)) {
            throw new InvalidParameterException("Invalid value type for parameter " + param.getName() + " ; expected type: " + param.getType());
        }
        this.valueMap.put(name, obj);
    }

    public void check() throws ParamException {
        for (ChartParam param : this.paramMap.values()) {
            if (param.isOptional() || this.valueMap.get(param.getName()) != null) continue;
            throw new MissingMandatoryParamException("No value given for mandatory parameter " + param.getName());
        }
    }

    public Object get(String name) {
        Object result = this.valueMap.get(name);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return null;
    }

    public String getString(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param == null || param.getType() == String.class) {
            return (String)this.get(name);
        }
        return null;
    }

    public Integer getInteger(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Integer.class) {
            return (Integer)this.get(name);
        }
        return null;
    }

    public Float getFloat(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Float.class) {
            return (Float)this.get(name);
        }
        return null;
    }

    public Double getDouble(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Double.class) {
            return (Double)this.get(name);
        }
        return null;
    }

    public Boolean getBoolean(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Boolean.class) {
            return (Boolean)this.get(name);
        }
        return null;
    }

    public Color getColor(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Color.class) {
            return (Color)this.get(name);
        }
        return null;
    }

    public Stroke getStroke(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Stroke.class) {
            return (Stroke)this.get(name);
        }
        return null;
    }

    public RectangleEdge getRectangleEdge(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == RectangleEdge.class) {
            return (RectangleEdge)this.get(name);
        }
        return null;
    }

    public HorizontalAlignment getHorizontalAlignment(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == HorizontalAlignment.class) {
            return (HorizontalAlignment)this.get(name);
        }
        return null;
    }

    public VerticalAlignment getVerticalAlignment(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == VerticalAlignment.class) {
            return (VerticalAlignment)this.get(name);
        }
        return null;
    }

    public Font getFont(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Font.class) {
            return (Font)this.get(name);
        }
        return null;
    }

    public RectangleInsets getRectangleInsets(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == RectangleInsets.class) {
            return (RectangleInsets)this.get(name);
        }
        return null;
    }

    public RectangleAnchor getRectangleAnchor(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == RectangleAnchor.class) {
            return (RectangleAnchor)this.get(name);
        }
        return null;
    }

    public PlotOrientation getPlotOrientation(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == PlotOrientation.class) {
            return (PlotOrientation)this.get(name);
        }
        return null;
    }

    public Point2D getPoint2D(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Point2D.class) {
            return (Point2D)this.get(name);
        }
        return null;
    }

    public Shape getShape(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Shape.class) {
            return (Shape)this.get(name);
        }
        return null;
    }

    public RangeType getRangeType(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == RangeType.class) {
            return (RangeType)this.get(name);
        }
        return null;
    }

    public NumberTickUnit getNumberTickUnit(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == NumberTickUnit.class) {
            return (NumberTickUnit)this.get(name);
        }
        return null;
    }

    public NumberFormat getNumberFormat(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == NumberFormat.class) {
            return (NumberFormat)this.get(name);
        }
        return null;
    }

    public DateFormat getDateFormat(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == DateFormat.class) {
            return (DateFormat)this.get(name);
        }
        return null;
    }

    public Date getDate(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Date.class) {
            return (Date)this.get(name);
        }
        return null;
    }

    public DateTickMarkPosition getDateTickMarkPosition(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == DateTickMarkPosition.class) {
            return (DateTickMarkPosition)this.get(name);
        }
        return null;
    }

    public DateTickUnit getDateTickUnit(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == DateTickUnit.class) {
            return (DateTickUnit)this.get(name);
        }
        return null;
    }

    public Class getClass(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Class.class) {
            return (Class)this.get(name);
        }
        return null;
    }

    public CategoryLabelPositions getCategoryLabelPositions(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == CategoryLabelPositions.class) {
            return (CategoryLabelPositions)this.get(name);
        }
        return null;
    }

    public List getList(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == List.class) {
            return (List)this.get(name);
        }
        return null;
    }

    public Map getMap(String name) {
        ChartParam param = (ChartParam)this.paramMap.get(name);
        if (param != null && param.getType() == Map.class) {
            return (Map)this.get(name);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String name : this.valueMap.keySet()) {
            sb.append(name + "=");
            sb.append(this.valueMap.get(name).toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

