/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.charts.Chart;
import com.xpn.xwiki.plugin.charts.ChartingPluginApi;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.params.DefaultChartParams;
import com.xpn.xwiki.render.macro.XWikiMacro;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.macro.LocaleMacro;
import org.radeox.macro.parameter.MacroParameter;

public class ChartingMacro
extends BaseLocaleMacro
implements LocaleMacro,
XWikiMacro {
    public String getLocaleKey() {
        return "macro.charting";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        try {
            String value;
            Chart chart;
            ChartParams chartParams;
            XWikiContext xcontext = (XWikiContext)params.getContext().get("xcontext");
            XWiki xwiki = xcontext.getWiki();
            ChartingPluginApi chartingPlugin = (ChartingPluginApi)xwiki.getPluginApi("charting", xcontext);
            if (chartingPlugin == null) {
                throw this.exception("ChartingPlugin not loaded");
            }
            try {
                chartParams = new ChartParams(params.getParams(), DefaultChartParams.getInstance(), true);
                chartParams.check();
            }
            catch (ParamException e) {
                throw this.exception("Parameter Exception", e);
            }
            try {
                chart = chartingPlugin.generateChart(chartParams, xcontext);
            }
            catch (GenerateException ge) {
                throw this.exception("Error generating chart", ge);
            }
            String title = chartParams.getString("title");
            Integer height = chartParams.getInteger("height");
            Integer width = chartParams.getInteger("width");
            Map imageAttr = chartParams.getMap("image_attributes");
            Map linkAttr = chartParams.getMap("link_attributes");
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("<a href=\"" + chart.getPageURL() + "\" ");
            if (title != null) {
                sbuffer.append("title=\"" + title + "\"");
            }
            if (linkAttr != null) {
                for (String name : linkAttr.keySet()) {
                    value = (String)imageAttr.get(name);
                    sbuffer.append(name + "=\"" + value + "\" ");
                }
            }
            sbuffer.append(">");
            sbuffer.append("<img src=\"");
            sbuffer.append(chart.getImageURL());
            sbuffer.append("\" ");
            if (title != null) {
                sbuffer.append("alt=\"" + title + "\" ");
            }
            sbuffer.append("height=\"" + height + "\" ");
            sbuffer.append("width=\"" + width + "\" ");
            if (imageAttr != null) {
                for (String name : imageAttr.keySet()) {
                    if (name != "height" && name != "width") {
                        value = (String)imageAttr.get(name);
                        sbuffer.append(name + "=\"" + value + "\" ");
                        continue;
                    }
                    throw this.exception("The image " + name + " can only be set by the " + name + "parameter");
                }
            }
            sbuffer.append("/>");
            sbuffer.append("</a>");
            writer.write(sbuffer.toString());
        }
        catch (XWikiException xwe) {
            writer.write("Charting exception: " + xwe.getFullMessage());
        }
        catch (Throwable t) {
            writer.write("Unexpected charting exception: " + t.getMessage());
            t.printStackTrace(new PrintWriter(writer));
        }
    }

    private XWikiException exception(String message) {
        return new XWikiException(5, 0, message);
    }

    private XWikiException exception(String message, Throwable throwable) {
        return new XWikiException(5, 0, throwable.getMessage(), throwable);
    }
}

