/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.charts.CustomXWikiRenderingEngine;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.source.TableDataSource;
import com.xpn.xwiki.render.PreTagSubstitution;
import com.xpn.xwiki.render.XWikiRenderer;
import com.xpn.xwiki.render.XWikiRenderingEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.radeox.macro.table.Table;
import org.radeox.macro.table.TableBuilder;

public class RadeoxHelper {
    private static volatile XWikiRenderingEngine customEngine;
    private XWikiRenderer radeoxRenderer;
    private XWikiContext context;
    private XWikiDocument document;
    private static final String TABLE = "{table}";

    public RadeoxHelper(XWikiDocument document, XWikiContext context) throws XWikiException {
        this.context = context;
        this.radeoxRenderer = context.getWiki().getRenderingEngine().getRenderer("wiki");
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPreRadeoxContent() {
        try {
            if (customEngine != null) return customEngine.renderDocument(this.document, this.context);
            Class<RadeoxHelper> clazz = RadeoxHelper.class;
            synchronized (RadeoxHelper.class) {
                if (customEngine != null) return customEngine.renderDocument(this.document, this.context);
                customEngine = new CustomXWikiRenderingEngine(this.context.getWiki(), this.context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return customEngine.renderDocument(this.document, this.context);
            }
        }
        catch (XWikiException e) {
            return this.document.getContent();
        }
    }

    public String[] getTableStrings() {
        ArrayList<String> tables = new ArrayList<String>();
        String content = this.getPreRadeoxContent();
        content = new PreTagSubstitution(this.context.getUtil(), true).substitute(content);
        int index = Integer.MIN_VALUE;
        int lastIndex = Integer.MIN_VALUE;
        boolean opened = false;
        while (index < content.length()) {
            lastIndex = index;
            if ((index = content.indexOf(TABLE, index + TABLE.length())) == -1) break;
            if (opened) {
                tables.add(content.substring(lastIndex + TABLE.length(), index).trim());
            }
            opened = !opened;
        }
        return tables.toArray(new String[tables.size()]);
    }

    public Table[] getTables() {
        String[] tableStrings = this.getTableStrings();
        Table[] tables = new Table[tableStrings.length];
        for (int i = 0; i < tableStrings.length; ++i) {
            tables[i] = this.buildTable(tableStrings[i]);
        }
        return tables;
    }

    public String getTableString(int idx) {
        String content = this.getPreRadeoxContent();
        content = new PreTagSubstitution(this.context.getUtil(), true).substitute(content);
        int index = Integer.MIN_VALUE;
        int lastIndex = Integer.MIN_VALUE;
        int i = -1;
        boolean opened = false;
        while (index < content.length() && i < idx) {
            lastIndex = index;
            if ((index = content.indexOf(TABLE, index + TABLE.length())) == -1) break;
            if (opened) {
                ++i;
            }
            opened = !opened;
        }
        if (i == idx) {
            return content.substring(lastIndex + TABLE.length(), index).trim();
        }
        return null;
    }

    public Table getTable(int idx) {
        String tableString = this.getTableString(idx);
        if (tableString != null) {
            return this.buildTable(tableString);
        }
        return null;
    }

    public String getRenderedTable(int idx) {
        String tableString = this.getTableString(idx);
        if (tableString != null) {
            return this.radeoxRenderer.render("{table}\n" + tableString + "\n{table}", null, null, this.context);
        }
        return null;
    }

    private Table buildTable(String content) {
        content = content.trim() + "\n";
        Table table = TableBuilder.build((String)content);
        table.calc();
        return table;
    }

    public int getTableColumnCount(Table t) {
        try {
            return TableDataSource.getTableColumnCount(t);
        }
        catch (DataSourceException e) {
            return 0;
        }
    }

    public int getTableRowCount(Table t) {
        try {
            return TableDataSource.getTableRowCount(t);
        }
        catch (DataSourceException e) {
            return 0;
        }
    }

    public String getCell(Table table, int columnIndex, int rowIndex) {
        try {
            return table.getXY(columnIndex, rowIndex).toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String buildMacro(String name, Map params) {
        StringBuffer sb = new StringBuffer();
        sb.append("{" + name);
        if (!params.isEmpty()) {
            sb.append(":");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                String paramValue = (String)params.get(paramName);
                sb.append(paramName + "=" + paramValue);
                if (!it.hasNext()) continue;
                sb.append("|");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public char getColumn(int columnIndex) {
        return (char)(65 + columnIndex);
    }
}

