/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.MissingArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.LocaleChartParam;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateFormatChartParam
extends LocaleChartParam {
    public static final String TYPE = "type";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String DATETIME = "datetime";
    public static final String CUSTOM = "custom";
    public static final String DATE_STYLE = "date_style";
    public static final String TIME_STYLE = "time_style";
    public static final String SHORT = "short";
    public static final String MEDIUM = "medium";
    public static final String LONG = "long";
    public static final String FULL = "full";
    public static final String PATTERN = "pattern";
    private Map styleChoices;

    public DateFormatChartParam(String name) {
        super(name);
        this.init();
    }

    public DateFormatChartParam(String name, boolean optional) {
        super(name, optional);
        this.init();
    }

    public void init() {
        this.styleChoices = new HashMap(4);
        this.styleChoices.put(SHORT, new Integer(3));
        this.styleChoices.put(MEDIUM, new Integer(2));
        this.styleChoices.put(LONG, new Integer(1));
        this.styleChoices.put(FULL, new Integer(0));
    }

    @Override
    public Class getType() {
        return DateFormat.class;
    }

    @Override
    public Object convert(String value) throws ParamException {
        Locale locale;
        Integer timeStyle;
        Integer dateStyle;
        Map map = this.parseMap(value);
        try {
            dateStyle = (Integer)this.getChoiceArg(map, DATE_STYLE, this.styleChoices);
        }
        catch (MissingArgumentException e) {
            dateStyle = null;
        }
        try {
            timeStyle = (Integer)this.getChoiceArg(map, TIME_STYLE, this.styleChoices);
        }
        catch (MissingArgumentException e) {
            timeStyle = null;
        }
        try {
            locale = (Locale)super.convert(value);
        }
        catch (MissingArgumentException e) {
            locale = null;
        }
        String type = this.getStringArg(map, TYPE);
        if (type.equals(DATE)) {
            if (dateStyle != null) {
                if (locale != null) {
                    return DateFormat.getDateInstance(dateStyle, locale);
                }
                return DateFormat.getDateInstance(dateStyle);
            }
            return DateFormat.getDateInstance();
        }
        if (type.equals(TIME)) {
            if (timeStyle != null) {
                if (locale != null) {
                    return DateFormat.getTimeInstance(timeStyle, locale);
                }
                return DateFormat.getTimeInstance(timeStyle);
            }
            return DateFormat.getDateInstance();
        }
        if (type.equals(DATETIME)) {
            if (dateStyle != null && timeStyle != null) {
                if (locale != null) {
                    return DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                }
                return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
            }
            return DateFormat.getDateTimeInstance();
        }
        if (type.equals(CUSTOM)) {
            String pattern = this.getStringArg(map, PATTERN);
            if (locale != null) {
                return new SimpleDateFormat(pattern, locale);
            }
            return new SimpleDateFormat(pattern);
        }
        throw new InvalidArgumentException("Invalid value for parameter " + this.getName() + ": Unexpected value for type argument: " + type);
    }
}

