/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidParamException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.AbstractChartParam;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

public class StrokeChartParam
extends AbstractChartParam {
    private Map capChoices = new HashMap();
    private Map joinChoices = new HashMap();

    public StrokeChartParam(String name) {
        super(name);
        this.init();
    }

    public StrokeChartParam(String name, boolean optional) {
        super(name, optional);
        this.init();
    }

    @Override
    public Class getType() {
        return Stroke.class;
    }

    public void init() {
        this.capChoices.put("butt", new Integer(0));
        this.capChoices.put("round", new Integer(1));
        this.capChoices.put("square", new Integer(2));
        this.joinChoices.put("miter", new Integer(0));
        this.joinChoices.put("round", new Integer(1));
        this.joinChoices.put("bevel", new Integer(2));
    }

    @Override
    public Object convert(String value) throws ParamException {
        Map map = this.parseMap(value);
        switch (map.size()) {
            case 0: {
                return new BasicStroke();
            }
            case 1: {
                return new BasicStroke(this.getFloatArg(map, "width"));
            }
            case 3: {
                return new BasicStroke(this.getFloatArg(map, "width"), this.getCapParam(map, "cap"), this.getJoinParam(map, "join"));
            }
            case 4: {
                return new BasicStroke(this.getFloatArg(map, "width"), this.getCapParam(map, "cap"), this.getJoinParam(map, "join"), this.getFloatArg(map, "miterlimit"));
            }
            case 6: {
                return new BasicStroke(this.getFloatArg(map, "width"), this.getCapParam(map, "cap"), this.getJoinParam(map, "join"), this.getFloatArg(map, "miterlimit"), this.toFloatArray(this.getListArg(map, "dash")), this.getFloatArg(map, "dash_phase"));
            }
        }
        throw new InvalidParamException("Invalid value for the parameter " + this.getName() + ": Invalid number of arguments: " + map.size());
    }

    private int getCapParam(Map map, String name) throws ParamException {
        return (Integer)this.getChoiceArg(map, name, this.capChoices);
    }

    private int getJoinParam(Map map, String name) throws ParamException {
        return (Integer)this.getChoiceArg(map, name, this.joinChoices);
    }
}

