/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidParamException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.AbstractChartParam;
import com.xpn.xwiki.plugin.charts.params.ChartParam;
import com.xpn.xwiki.plugin.charts.params.ChoiceChartParam;
import java.awt.Color;
import java.awt.Shape;
import java.util.Map;

public class ColorChartParam
extends AbstractChartParam {
    private ChartParam colorChoice;

    public ColorChartParam(String name) {
        super(name);
        this.init();
    }

    public ColorChartParam(String name, boolean optional) {
        super(name, optional);
        this.init();
    }

    @Override
    public Class getType() {
        return Color.class;
    }

    public void init() {
        this.colorChoice = new ChoiceChartParam(this.getName()){

            @Override
            protected void init() {
                this.addChoice("black", new Color(0));
                this.addChoice("silver", new Color(0xC0C0C0));
                this.addChoice("gray", new Color(0x808080));
                this.addChoice("white", new Color(0xFFFFFF));
                this.addChoice("maroon", new Color(0x800000));
                this.addChoice("red", new Color(0xFF0000));
                this.addChoice("purple", new Color(0x800080));
                this.addChoice("fuchsia", new Color(0xFF00FF));
                this.addChoice("green", new Color(32768));
                this.addChoice("lime", new Color(65280));
                this.addChoice("olive", new Color(0x808000));
                this.addChoice("yellow", new Color(0xFFFF00));
                this.addChoice("navy", new Color(128));
                this.addChoice("blue", new Color(255));
                this.addChoice("teal", new Color(32896));
                this.addChoice("aqua", new Color(65535));
                this.addChoice("orange", new Color(16753920));
                this.addChoice("transparent", new Color(0, 0, 0, 0));
            }

            @Override
            public Class getType() {
                return Shape.class;
            }
        };
    }

    @Override
    public Object convert(String value) throws ParamException {
        try {
            return this.colorChoice.convert(value);
        }
        catch (ParamException e) {
            if (value.length() == 0) {
                throw new InvalidParamException("Empty color parameter " + this.getName());
            }
            if (value.charAt(0) == '#') {
                int intValue;
                value = value.substring(1);
                try {
                    intValue = Integer.parseInt(value, 16);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidParamException("Color parameter " + this.getName() + " is not a valid hexadecimal number");
                }
                return new Color(intValue);
            }
            Map map = this.parseMap(value, 4);
            try {
                return new Color(this.getIntArg(map, "red"), this.getIntArg(map, "green"), this.getIntArg(map, "blue"), this.getIntArg(map, "alpha"));
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidParamException("Color component out of range (0-255)");
            }
        }
    }
}

