/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.model;

import org.xwiki.chart.model.ChartModel;

public class DefaultChartModel
implements ChartModel {
    private int rowCount;
    private int columnCount;
    private Number[][] data;
    private String[] rowHeaders;
    private String[] columnHeaders;

    public DefaultChartModel(Number[][] data) {
        this.rowCount = data.length;
        int n = this.columnCount = this.rowCount > 0 ? data[0].length : 0;
        if (this.rowCount == 0 || this.columnCount == 0) {
            throw new IllegalArgumentException("Invalid row count / column count.");
        }
        for (Number[] row : data) {
            if (row.length == this.columnCount) continue;
            throw new IllegalArgumentException("Incomplete data.");
        }
        this.data = data;
    }

    public DefaultChartModel(Number[][] data, String[] rowHeaders, String[] columnHeaders) {
        this(data);
        if (rowHeaders != null && rowHeaders.length != this.rowCount) {
            throw new IllegalArgumentException("Incomplete row headers.");
        }
        if (columnHeaders != null && columnHeaders.length != this.columnCount) {
            throw new IllegalArgumentException("Incomplete column headers.");
        }
        this.rowHeaders = rowHeaders;
        this.columnHeaders = columnHeaders;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Number getCellValue(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.rowCount && columnIndex >= 0 && columnIndex < this.columnCount) {
            return this.data[rowIndex][columnIndex];
        }
        throw new IllegalArgumentException(String.format("Invalid cell specified : (%d, %d).", rowIndex, columnIndex));
    }

    public String getRowHeader(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.rowCount) {
            return this.rowHeaders != null ? this.rowHeaders[rowIndex] : "R" + rowIndex;
        }
        throw new IllegalArgumentException(String.format("Invalid row index : [%s].", rowIndex));
    }

    public String getColumnHeader(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnCount) {
            return this.columnHeaders != null ? this.columnHeaders[columnIndex] : "C" + columnIndex;
        }
        throw new IllegalArgumentException(String.format("Invalid column index : [%s].", columnIndex));
    }
}

