/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.plot;

import java.util.Map;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.xwiki.chart.PlotGeneratorException;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;

public abstract class AbstractXYPlotGenerator
implements PlotGenerator {
    @Override
    public Plot generate(ChartModel model, Map<String, String> parameters) throws PlotGeneratorException {
        if (!(model.getDataset() instanceof XYDataset)) {
            throw new PlotGeneratorException("Incompatible dataset for xy plot.");
        }
        XYDataset dataset = (XYDataset)model.getDataset();
        if (!(model.getAxis(0) instanceof ValueAxis)) {
            throw new PlotGeneratorException("Incompatible axis 0 for xy plot.");
        }
        ValueAxis domainAxis = (ValueAxis)model.getAxis(0);
        if (!(model.getAxis(1) instanceof ValueAxis)) {
            throw new PlotGeneratorException("Incompatible axis 1 for xy plot.");
        }
        ValueAxis rangeAxis = (ValueAxis)model.getAxis(1);
        return new XYPlot(dataset, domainAxis, rangeAxis, this.getRenderer(parameters));
    }

    protected abstract XYItemRenderer getRenderer(Map<String, String> var1);
}

