/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal.protocol.attachmentjar;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.classloader.ExtendedURLStreamHandler;
import org.xwiki.classloader.internal.protocol.attachmentjar.AttachmentURLConnection;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;

@Component(value="attachmentjar")
public class AttachmentURLStreamHandler
extends URLStreamHandler
implements ExtendedURLStreamHandler {
    private static final String ATTACHMENT_JAR_PROTOCOL = "attachmentjar";
    private static final String ATTACHMENT_JAR_PREFIX = "attachmentjar://";
    @Requirement(value="current")
    private AttachmentReferenceResolver<String> attachmentReferenceResolver;
    @Requirement
    private DocumentAccessBridge documentAccessBridge;

    public String getProtocol() {
        return ATTACHMENT_JAR_PROTOCOL;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        AttachmentReference attachmentReference = this.attachmentReferenceResolver.resolve((Object)this.getAttachmentReference(url), new Object[0]);
        return new AttachmentURLConnection(url, attachmentReference, this.documentAccessBridge);
    }

    private String getAttachmentReference(URL url) {
        String urlAsString = url.toString();
        if (!urlAsString.startsWith(ATTACHMENT_JAR_PREFIX)) {
            throw new RuntimeException("An attachment JAR URL should start with [attachmentjar://], got [" + urlAsString + "]");
        }
        String attachmentReference = urlAsString.substring(ATTACHMENT_JAR_PREFIX.length());
        try {
            attachmentReference = URLDecoder.decode(attachmentReference, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to URL decode [" + attachmentReference + "] using UTF-8.", e);
        }
        return attachmentReference;
    }
}

