/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal.protocol.jar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarURLConnection
extends URLConnection
implements org.xwiki.classloader.internal.JarURLConnection {
    private URLStreamHandlerFactory handlerFactory;
    final JarOpener opener;
    boolean connected;
    JarFile jfile;
    JarEntry jentry;
    private URL jarFileURL;
    private String entryName;

    public JarURLConnection(URL url, JarOpener opener, URLStreamHandlerFactory handlerFactory) throws IOException {
        super(url);
        this.opener = opener;
        this.handlerFactory = handlerFactory;
        this.parseSpecs(url);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.jfile = this.opener.openJarFile(this);
        if (this.jfile != null && this.getEntryName() != null) {
            this.jentry = this.jfile.getJarEntry(this.getEntryName());
            if (this.jentry == null) {
                throw new FileNotFoundException("Entry " + this.getEntryName() + " not found in " + this.getJarFileURL());
            }
        }
        this.connected = true;
    }

    public synchronized JarFile getJarFile() throws IOException {
        this.connect();
        return this.jfile;
    }

    public synchronized JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jentry;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        return this.jfile.getInputStream(this.jentry);
    }

    public Permission getPermission() throws IOException {
        return this.getJarFileURL().openConnection().getPermission();
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        int separator = spec.indexOf(33);
        if (separator == -1) {
            throw new MalformedURLException("no ! found in url spec:" + spec);
        }
        String protocol = spec.substring(0, spec.indexOf(":"));
        this.jarFileURL = new URL(null, spec.substring(0, separator++), this.handlerFactory.createURLStreamHandler(protocol));
        this.entryName = null;
        if (++separator != spec.length()) {
            this.entryName = spec.substring(separator, spec.length());
            try {
                this.entryName = URLDecoder.decode(this.entryName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL decode [" + this.entryName + "] using UTF-8.", e);
            }
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public Attributes getAttributes() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getAttributes() : null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest man = this.getManifest();
        return man != null ? man.getMainAttributes() : null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getCertificates() : null;
    }

    public static interface JarOpener {
        public JarFile openJarFile(JarURLConnection var1) throws IOException;
    }
}

