/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.xwiki.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.NamespaceURLClassLoader;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public class ContextNamespaceURLClassLoader
extends NamespaceURLClassLoader {
    private WikiDescriptorManager wikis;
    private final ClassLoaderManager classLoaderManager;
    private String cachedCurrentWiki;
    private NamespaceURLClassLoader currentClassLoader;

    public ContextNamespaceURLClassLoader(WikiDescriptorManager wikis, ClassLoaderManager classLoaderManager) {
        super(new URI[0], Thread.currentThread().getContextClassLoader(), null);
        this.wikis = wikis;
        this.classLoaderManager = classLoaderManager;
    }

    private NamespaceURLClassLoader getCurrentClassLoader() {
        String currentWiki = this.wikis.getCurrentWikiId();
        if (this.currentClassLoader == null || !Objects.equals(currentWiki, this.cachedCurrentWiki)) {
            this.currentClassLoader = this.classLoaderManager.getURLClassLoader(currentWiki != null ? "wiki:" + currentWiki : null, false);
            if (this.currentClassLoader == null) {
                this.currentClassLoader = new NamespaceURLClassLoader(new URI[0], ContextNamespaceURLClassLoader.getSystemClassLoader(), null);
            }
            this.cachedCurrentWiki = currentWiki;
        }
        return this.currentClassLoader;
    }

    public String getNamespace() {
        return this.getCurrentClassLoader().getNamespace();
    }

    public void addURL(URL url) {
        this.getCurrentClassLoader().addURL(url);
    }

    public void addURLs(List<URL> urls) {
        this.getCurrentClassLoader().addURLs(urls);
    }

    public URL[] getURLs() {
        return this.getCurrentClassLoader().getURLs();
    }

    public URL getResource(String name) {
        return this.getCurrentClassLoader().getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getCurrentClassLoader().getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.getCurrentClassLoader().getResourceAsStream(name);
    }

    public URL findResource(String name) {
        return this.getCurrentClassLoader().findResource(name);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        return this.getCurrentClassLoader().findResources(name);
    }

    public void close() throws IOException {
        this.getCurrentClassLoader().close();
    }

    public void clearAssertionStatus() {
        this.getCurrentClassLoader().clearAssertionStatus();
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.getCurrentClassLoader().setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.getCurrentClassLoader().setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.getCurrentClassLoader().setPackageAssertionStatus(packageName, enabled);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getCurrentClassLoader().loadClass(name);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.getCurrentClassLoader().loadClass(name);
    }
}

