/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="component.multi.WikiDeletedListener")
public class WikiDeletedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new WikiDeletedEvent());
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private Logger logger;

    public String getName() {
        return "component.multi.WikiDeletedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object o, Object context) {
        String wiki = ((WikiDeletedEvent)event).getWikiId();
        ComponentManager componentManager = this.componentManagerManager.getComponentManager(new WikiNamespace(wiki).serialize(), false);
        if (componentManager instanceof Disposable) {
            try {
                ((Disposable)componentManager).dispose();
            }
            catch (ComponentLifecycleException e) {
                this.logger.error(String.format("Failed to dispose component manager for wiki [%s]", wiki), (Throwable)e);
            }
        }
    }
}

