/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.internal.ComponentManagerFactory;
import org.xwiki.component.internal.DelegateComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenericComponentManager
extends DelegateComponentManager {
    private Map<String, ComponentManager> componentManagers = new HashMap<String, ComponentManager>();
    @Requirement
    private ComponentManagerFactory componentManagerFactory;
    private ComponentManager internalParent;

    protected abstract String getKey();

    @Override
    public ComponentManager getComponentManager() {
        ComponentManager componentManager = this.componentManagers.get(this.getKey());
        if (componentManager == null && (componentManager = this.getInternalParent()) == null) {
            throw new RuntimeException("Key-based Proxy Component Managers should always have a Parent Component Manager defined so that it can be used if there's no Component Manager for the given key");
        }
        return componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) throws ComponentRepositoryException {
        AbstractGenericComponentManager abstractGenericComponentManager = this;
        synchronized (abstractGenericComponentManager) {
            String key = this.getKey();
            if (!this.componentManagers.containsKey(key)) {
                this.componentManagers.put(key, this.componentManagerFactory.createComponentManager(this.getInternalParent()));
            }
            if (componentInstance == null) {
                super.registerComponent(componentDescriptor);
            } else {
                super.registerComponent(componentDescriptor, componentInstance);
            }
        }
    }

    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    @Override
    public void unregisterComponent(Class<?> role, String roleHint) {
        super.unregisterComponent(role, roleHint);
    }

    protected ComponentManager getInternalParent() {
        return this.internalParent;
    }

    protected void setInternalParent(ComponentManager parentComponentManager) {
        this.internalParent = parentComponentManager;
    }
}

