/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.script;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="component")
@Singleton
public class ComponentScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.component.error";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private Execution execution;

    public ComponentManager getComponentManager() {
        return this.bridge.hasProgrammingRights() ? (ComponentManager)this.componentManagerProvider.get() : null;
    }

    public ComponentManager getComponentManager(String namespace) {
        return this.bridge.hasProgrammingRights() ? this.componentManagerManager.getComponentManager(namespace, false) : null;
    }

    public <T> T getInstance(Type roleType) {
        Object result = null;
        ComponentManager cm = this.getComponentManager();
        if (cm != null) {
            try {
                result = cm.getInstance(roleType);
            }
            catch (ComponentLookupException e) {
                result = null;
                this.setError((Exception)((Object)e));
            }
        }
        return (T)result;
    }

    public <T> T getInstance(Type roleType, String roleHint) {
        Object result = null;
        ComponentManager cm = this.getComponentManager();
        if (cm != null) {
            try {
                result = cm.getInstance(roleType, roleHint);
            }
            catch (ComponentLookupException e) {
                result = null;
                this.setError((Exception)((Object)e));
            }
        }
        return (T)result;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    private void setError(Exception exception) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)exception);
    }
}

