/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponentRuntimeException;
import org.xwiki.component.wiki.internal.WikiComponentMethodExecutor;
import org.xwiki.component.wiki.internal.WikiMethodOutputHandler;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Singleton
public class DefaultWikiComponentMethodExecutor
implements WikiComponentMethodExecutor {
    private static final String XWIKI_CONTEXT_DOC_KEY = "doc";
    @Inject
    private Execution execution;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer blockRenderer;
    @Inject
    private ConverterManager converterManager;
    @Inject
    private DocumentAccessBridge dab;

    private void prepareMethodContext(Map<String, Object> methodContext, Object[] args) {
        methodContext.put("output", new WikiMethodOutputHandler());
        HashMap<Integer, Object> inputs = new HashMap<Integer, Object>();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                inputs.put(i, args[i]);
            }
        }
        methodContext.put("input", inputs);
    }

    private Object castRenderedContent(XDOM xdom, Method method) throws WikiComponentRuntimeException {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.blockRenderer.render((Block)xdom, (WikiPrinter)printer);
        String contentResult = printer.toString();
        try {
            return this.converterManager.convert(method.getGenericReturnType(), (Object)contentResult);
        }
        catch (ConversionException e) {
            throw new WikiComponentRuntimeException(String.format("Failed to convert result [%s] to type [%s] for method [%s.%s]", contentResult, method.getGenericReturnType(), method.getDeclaringClass().getName(), method.getName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Method method, Object[] args, DocumentReference componentDocumentReference, XDOM xdom, Syntax syntax, Map<String, Object> methodContext) throws WikiComponentRuntimeException {
        Map xwikiContext = (Map)this.execution.getContext().getProperty("xwikicontext");
        this.prepareMethodContext(methodContext, args);
        xwikiContext.put("method", methodContext);
        Object contextDoc = xwikiContext.get(XWIKI_CONTEXT_DOC_KEY);
        try {
            Object object;
            try {
                xwikiContext.put(XWIKI_CONTEXT_DOC_KEY, this.dab.getDocumentInstance(componentDocumentReference));
            }
            catch (Exception e) {
                throw new WikiComponentRuntimeException(String.format("Failed to load wiki component document [%s]", componentDocumentReference), e);
            }
            XDOM transformedXDOM = xdom.clone();
            try {
                TransformationContext transformationContext = new TransformationContext(transformedXDOM, syntax);
                transformationContext.setId(method.getClass().getName() + "#" + method.getName());
                ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, transformationContext, (Block)transformedXDOM);
            }
            catch (TransformationException e) {
                throw new WikiComponentRuntimeException(String.format("Error while executing wiki component macro transformation for method [%s]", method.getName()), e);
            }
            if (!method.getReturnType().getName().equals("void")) {
                if (methodContext.get("output") != null && ((WikiMethodOutputHandler)methodContext.get("output")).getValue() != null) {
                    object = method.getReturnType().cast(((WikiMethodOutputHandler)methodContext.get("output")).getValue());
                    return object;
                }
                object = this.castRenderedContent(transformedXDOM, method);
                return object;
            }
            object = null;
            return object;
        }
        finally {
            if (contextDoc != null) {
                xwikiContext.put(XWIKI_CONTEXT_DOC_KEY, contextDoc);
            }
        }
    }
}

