/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal.bridge;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.AbstractDocumentEvent;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiObjectComponentBuilder;
import org.xwiki.component.wiki.internal.bridge.WikiObjectComponentManagerEventListenerProxy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="defaultWikiObjectComponentManagerEventListener")
@Singleton
public class DefaultWikiObjectComponentManagerEventListener
extends AbstractEventListener {
    public static final String EVENT_LISTENER_NAME = "defaultWikiObjectComponentManagerEventListener";
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private WikiObjectComponentManagerEventListenerProxy wikiObjectComponentManagerEventListenerProxy;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private Logger logger;

    public DefaultWikiObjectComponentManagerEventListener() {
        super(EVENT_LISTENER_NAME, new Event[]{new ApplicationReadyEvent(), new WikiReadyEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof AbstractDocumentEvent) {
            this.handleDocumentEvents((AbstractDocumentEvent)event, (XWikiDocument)source);
        } else if (event instanceof ApplicationReadyEvent || event instanceof WikiReadyEvent) {
            this.wikiObjectComponentManagerEventListenerProxy.registerAllObjectComponents();
        }
    }

    private void handleDocumentEvents(AbstractDocumentEvent event, XWikiDocument document) {
        if (event instanceof DocumentUpdatedEvent || event instanceof DocumentDeletedEvent) {
            this.unRegisterObjectComponents(document.getOriginalDocument());
        }
        if (event instanceof DocumentCreatedEvent || event instanceof DocumentUpdatedEvent) {
            this.registerObjectComponents(document);
        }
    }

    private void registerObjectComponents(XWikiDocument document) {
        for (Map.Entry entry : document.getXObjects().entrySet()) {
            WikiObjectComponentBuilder componentBuilder = this.getAssociatedComponentBuilder((DocumentReference)entry.getKey());
            if (componentBuilder == null) continue;
            for (BaseObject baseObject : (List)entry.getValue()) {
                if (baseObject == null) continue;
                this.wikiObjectComponentManagerEventListenerProxy.registerObjectComponents((ObjectReference)baseObject.getReference(), baseObject, componentBuilder);
            }
        }
    }

    private void unRegisterObjectComponents(XWikiDocument document) {
        for (Map.Entry entry : document.getXObjects().entrySet()) {
            WikiObjectComponentBuilder componentBuilder = this.getAssociatedComponentBuilder((DocumentReference)entry.getKey());
            if (componentBuilder == null) continue;
            for (BaseObject baseObject : (List)entry.getValue()) {
                if (baseObject == null) continue;
                this.wikiObjectComponentManagerEventListenerProxy.unregisterObjectComponents((ObjectReference)baseObject.getReference());
            }
        }
    }

    private WikiObjectComponentBuilder getAssociatedComponentBuilder(DocumentReference xClassReference) {
        try {
            String serializedXClassReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)xClassReference, new Object[0]);
            if (this.componentManager.hasComponent(WikiObjectComponentBuilder.class, serializedXClassReference)) {
                return (WikiObjectComponentBuilder)this.componentManager.getInstance(WikiObjectComponentBuilder.class, serializedXClassReference);
            }
            serializedXClassReference = (String)this.localEntityReferenceSerializer.serialize((EntityReference)xClassReference, new Object[0]);
            if (this.componentManager.hasComponent(WikiObjectComponentBuilder.class, serializedXClassReference)) {
                return (WikiObjectComponentBuilder)this.componentManager.getInstance(WikiObjectComponentBuilder.class, serializedXClassReference);
            }
            return null;
        }
        catch (ComponentLookupException e) {
            this.logger.error(String.format("Unable to find a WikiObjectComponentBuilder associated to the helper [%s]: %s", new Object[]{xClassReference, e}));
            return null;
        }
    }
}

