/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;

public abstract class AbstractBaseObjectWikiComponent
implements WikiComponent {
    public static final String XPROPERTY_SCOPE = "scope";
    protected ObjectReference objectReference;
    protected DocumentReference authorReference;
    protected Type roleType;
    protected String roleHint;
    protected WikiComponentScope scope = WikiComponentScope.WIKI;

    public AbstractBaseObjectWikiComponent(BaseObject baseObject, Type roleType, String roleHint) {
        this.objectReference = (ObjectReference)baseObject.getReference();
        this.authorReference = baseObject.getOwnerDocument().getAuthorReference();
        this.roleType = roleType;
        this.roleHint = roleHint;
        this.scope = WikiComponentScope.fromString(baseObject.getStringValue(XPROPERTY_SCOPE));
    }

    @Override
    public DocumentReference getDocumentReference() {
        return this.objectReference.getDocumentReference();
    }

    @Override
    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    @Override
    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    @Override
    public Type getRoleType() {
        return this.roleType;
    }

    @Override
    public String getRoleHint() {
        return this.roleHint;
    }

    @Override
    public WikiComponentScope getScope() {
        return this.scope;
    }
}

